/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.network.handler;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.orbyfied.osf.network.NetworkHandler;
import net.orbyfied.osf.network.NetworkManager;
import net.orbyfied.osf.network.Packet;
import net.orbyfied.osf.network.PacketType;
import net.orbyfied.osf.util.security.EncryptionProfile;

public class SocketNetworkHandler
extends NetworkHandler<SocketNetworkHandler> {
    Executor executor = Executors.newSingleThreadExecutor();
    Socket socket;
    DataInputStream inputStream;
    DataOutputStream outputStream;
    ObjectInputStream objectInput;
    ObjectOutputStream objectOutput;
    Consumer<Throwable> disconnectHandler;
    EncryptionProfile encryptionProfile;
    boolean autoEncrypt;

    public SocketNetworkHandler(NetworkManager manager, NetworkHandler parent) {
        super(manager, parent);
    }

    @Override
    protected void handle(Packet packet) {
        super.handle(packet);
        this.node().handle(this, packet);
    }

    public SocketNetworkHandler withDisconnectHandler(Consumer<Throwable> consumer) {
        this.disconnectHandler = consumer;
        return this;
    }

    public synchronized SocketNetworkHandler withEncryptionProfile(EncryptionProfile profile) {
        this.encryptionProfile = profile;
        return this;
    }

    public synchronized SocketNetworkHandler autoEncrypt(boolean b) {
        this.autoEncrypt = b;
        return this;
    }

    @Override
    protected boolean canHandleAsync(Packet packet) {
        return false;
    }

    @Override
    protected void scheduleHandleAsync(Packet packet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketNetworkHandler fatalClose() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this;
    }

    public SocketNetworkHandler connect(Socket socket) {
        this.socket = socket;
        try {
            this.inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            this.outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            this.objectInput = new ObjectInputStream(this.inputStream);
            this.objectOutput = new ObjectOutputStream(this.outputStream);
        }
        catch (Exception e) {
            this.fatalClose();
            LOGGER.err("socket_connect", "Error while connecting to " + socket.getRemoteSocketAddress(), new Object[0]);
            e.printStackTrace();
        }
        return this;
    }

    public SocketNetworkHandler disconnect() {
        this.stop();
        return this;
    }

    public SocketNetworkHandler sendSyncRaw(Packet packet) {
        try {
            this.outputStream.writeByte(0);
            this.outputStream.writeInt(packet.type().identifier().hashCode());
            packet.type().serialize(packet, this.objectOutput);
            this.outputStream.flush();
            return this;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return this;
        }
    }

    public CompletableFuture<SocketNetworkHandler> sendAsyncRaw(Packet packet) {
        return CompletableFuture.supplyAsync(() -> {
            this.sendSyncRaw(packet);
            return this;
        }, this.executor);
    }

    public SocketNetworkHandler sendSync(Packet packet) {
        if (this.autoEncrypt && this.encryptionProfile != null) {
            return this.sendSyncEncrypted(packet, this.encryptionProfile);
        }
        return this.sendSyncRaw(packet);
    }

    public CompletableFuture<SocketNetworkHandler> sendAsync(Packet packet) {
        return CompletableFuture.supplyAsync(() -> {
            this.sendSync(packet);
            return this;
        }, this.executor);
    }

    public SocketNetworkHandler sendSyncEncrypted(Packet packet, EncryptionProfile encryption) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream stream = encryption.encryptingOutputStream(baos).toDataStream();
            ObjectOutputStream oos = new ObjectOutputStream(stream);
            packet.type().serialize(packet, oos);
            stream.flush();
            this.outputStream.writeByte(1);
            this.outputStream.writeInt(packet.type().identifier().hashCode());
            byte[] encrypted = baos.toByteArray();
            this.outputStream.writeInt(encrypted.length);
            this.outputStream.write(encrypted);
            this.outputStream.flush();
            return this;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return this;
        }
    }

    public CompletableFuture<SocketNetworkHandler> sendAsyncEncrypted(Packet packet, EncryptionProfile profile) {
        return CompletableFuture.supplyAsync(() -> {
            this.sendSyncEncrypted(packet, profile);
            return this;
        }, this.executor);
    }

    public boolean isOpen() {
        if (this.socket == null) {
            return false;
        }
        return !this.socket.isClosed();
    }

    @Override
    protected NetworkHandler.WorkerThread createWorkerThread() {
        return new SocketWorkerThread();
    }

    public Socket getSocket() {
        return this.socket;
    }

    class SocketWorkerThread
    extends NetworkHandler.WorkerThread {
        SocketWorkerThread() {
            super(SocketNetworkHandler.this);
        }

        @Override
        public void runSafe() throws Throwable {
            long pC = 0L;
            Throwable t = null;
            try {
                while (!SocketNetworkHandler.this.socket.isClosed() && SocketNetworkHandler.this.active.get()) {
                    ObjectInputStream stream;
                    byte encryptedFlag = SocketNetworkHandler.this.inputStream.readByte();
                    int packetTypeId = SocketNetworkHandler.this.inputStream.readInt();
                    PacketType<? extends Packet> packetType = SocketNetworkHandler.this.manager.getByHash(packetTypeId);
                    if (packetType == null) continue;
                    ++pC;
                    if (encryptedFlag == 0) {
                        stream = SocketNetworkHandler.this.objectInput;
                    } else {
                        if (SocketNetworkHandler.this.encryptionProfile == null) {
                            throw new IllegalArgumentException("can not decrypt encrypted packet, no decryption profile set");
                        }
                        int dataLen = SocketNetworkHandler.this.inputStream.readInt();
                        byte[] encrypted = SocketNetworkHandler.this.inputStream.readNBytes(dataLen);
                        ByteArrayInputStream bais = new ByteArrayInputStream(encrypted);
                        stream = new ObjectInputStream(SocketNetworkHandler.this.encryptionProfile.decryptingInputStream(bais).toDataStream());
                    }
                    Packet packet = packetType.deserialize(stream);
                    SocketNetworkHandler.this.handle(packet);
                }
            }
            catch (Throwable t1) {
                t = t1;
            }
            Throwable ft = null;
            if (t != null) {
                ft = t;
            }
            if (SocketNetworkHandler.this.disconnectHandler != null) {
                SocketNetworkHandler.this.disconnectHandler.accept(ft);
            }
        }
    }
}

