/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.network.handler;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import net.orbyfied.osf.network.NetworkHandler;
import net.orbyfied.osf.network.NetworkManager;
import net.orbyfied.osf.network.Packet;

public class UtilityNetworkHandler
extends NetworkHandler<UtilityNetworkHandler> {
    Deque<Runnable> tasks = new ArrayDeque<Runnable>();
    Object lock = new Object();
    AtomicBoolean waiting = new AtomicBoolean(false);

    public UtilityNetworkHandler(NetworkManager manager, NetworkHandler parent) {
        super(manager, parent);
    }

    @Override
    protected NetworkHandler.WorkerThread createWorkerThread() {
        return new UtilityWorkerThread();
    }

    @Override
    protected void handle(Packet packet) {
        super.handle(packet);
        this.node.handle(this, packet);
    }

    @Override
    protected boolean canHandleAsync(Packet packet) {
        return true;
    }

    @Override
    protected void scheduleHandleAsync(Packet packet) {
        this.schedule(() -> this.handle(packet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UtilityNetworkHandler schedule(Runnable runnable) {
        Object object = this.tasks;
        synchronized (object) {
            this.tasks.add(runnable);
        }
        if (this.waiting.get()) {
            object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        return this;
    }

    class UtilityWorkerThread
    extends NetworkHandler.WorkerThread {
        UtilityWorkerThread() {
            super(UtilityNetworkHandler.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runSafe() throws Throwable {
            while (UtilityNetworkHandler.this.active.get()) {
                Object object = UtilityNetworkHandler.this.tasks;
                synchronized (object) {
                    while (!UtilityNetworkHandler.this.tasks.isEmpty()) {
                        Runnable task = UtilityNetworkHandler.this.tasks.poll();
                        task.run();
                    }
                }
                object = UtilityNetworkHandler.this.lock;
                synchronized (object) {
                    UtilityNetworkHandler.this.waiting.set(true);
                    UtilityNetworkHandler.this.lock.wait();
                    UtilityNetworkHandler.this.waiting.set(false);
                }
            }
        }
    }
}

