/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.resource;

import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.orbyfied.osf.resource.ServerResource;
import net.orbyfied.osf.resource.ServerResourceManager;

public class ServerResourceHandle<R extends ServerResource> {
    final ServerResourceManager manager;
    final UUID uuid;
    WeakReference<R> resource;
    volatile boolean acquired = false;

    public ServerResourceHandle(ServerResourceManager manager, UUID uuid) {
        this.manager = manager;
        this.uuid = uuid;
    }

    public ServerResourceHandle(ServerResourceManager manager, R resource) {
        this.manager = manager;
        this.uuid = ((ServerResource)resource).universalID();
        this.resource = new WeakReference<R>(resource);
    }

    public ServerResourceManager manager() {
        return this.manager;
    }

    public UUID universalID() {
        return this.uuid;
    }

    public boolean isNullID() {
        return ServerResourceManager.NULL_ID.equals(this.uuid);
    }

    public R getOrNull() {
        if (this.resource == null) {
            return null;
        }
        return (R)((ServerResource)this.resource.get());
    }

    public R getOrLoad() {
        if (this.resource == null || this.resource.get() == null) {
            this.resource = new WeakReference(this.manager.loadResourceUnwrapped(this.uuid));
        }
        return (R)((ServerResource)this.resource.get());
    }

    public CompletableFuture<R> getOrLoadAsync() {
        if (this.resource == null || this.resource.get() == null) {
            return CompletableFuture.supplyAsync(() -> {
                Object res = this.manager.loadResourceUnwrapped(this.uuid);
                WeakReference<R> weakReference = this.resource;
                synchronized (weakReference) {
                    this.resource = new WeakReference(res);
                }
                return res;
            });
        }
        CompletableFuture<ServerResource> future = new CompletableFuture<ServerResource>();
        future.complete((ServerResource)this.resource.get());
        return future;
    }

    public ServerResourceHandle<R> useOrNot(Consumer<R> consumer) {
        R resource = this.getOrNull();
        if (resource != null) {
            consumer.accept(resource);
        }
        return this;
    }

    public ServerResourceHandle<R> ifUnloaded(Consumer<ServerResourceHandle<R>> consumer) {
        if (this.getOrNull() == null) {
            consumer.accept(this);
        }
        return this;
    }

    public ServerResourceHandle<R> useOrNull(Consumer<R> consumer) {
        R resource = this.getOrNull();
        consumer.accept(resource);
        return this;
    }

    public ServerResourceHandle<R> useOrLoad(Consumer<R> consumer) {
        R resource = this.getOrLoad();
        consumer.accept(resource);
        return this;
    }

    public R acquireAndGet() {
        return this.acquire().getOrNull();
    }

    public ServerResourceHandle<R> acquireAndUse(Consumer<R> consumer) {
        R resource = this.acquire().getOrNull();
        if (consumer != null) {
            consumer.accept(resource);
        }
        return this;
    }

    public ServerResourceHandle<R> acquire() {
        if (!this.acquired) {
            this.manager.doHandleAcquire(this);
            this.acquired = true;
        }
        return this;
    }

    public ServerResourceHandle<R> release() {
        if (this.acquired) {
            this.manager.doHandleRelease(this);
            this.acquired = false;
        }
        return this;
    }
}

