/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.resource;

import com.mongodb.Function;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.orbyfied.j8.event.ComplexEventBus;
import net.orbyfied.j8.event.util.Pipelines;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.reflect.Reflector;
import net.orbyfied.osf.db.Database;
import net.orbyfied.osf.db.DatabaseItem;
import net.orbyfied.osf.db.DatabaseManager;
import net.orbyfied.osf.db.DatabaseType;
import net.orbyfied.osf.db.QueryPool;
import net.orbyfied.osf.db.impl.MongoDatabaseItem;
import net.orbyfied.osf.resource.ResourceService;
import net.orbyfied.osf.resource.ServerResource;
import net.orbyfied.osf.resource.ServerResourceHandle;
import net.orbyfied.osf.resource.ServerResourceType;
import net.orbyfied.osf.resource.event.ResourceCreateEvent;
import net.orbyfied.osf.resource.event.ResourceHandleAcquireEvent;
import net.orbyfied.osf.resource.event.ResourceHandleReleaseEvent;
import net.orbyfied.osf.resource.event.ResourceUnloadEvent;
import net.orbyfied.osf.resource.impl.ResourceGCService;
import net.orbyfied.osf.util.Values;
import net.orbyfied.osf.util.logging.EventLog;
import net.orbyfied.osf.util.logging.Logging;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ServerResourceManager {
    public static final EventLog LOGGER = Logging.getEventLog("ServerResources");
    private static final Reflector reflector = new Reflector("ServerResources");
    protected static final Random RANDOM = new Random(System.currentTimeMillis() * 91L ^ System.nanoTime() << 3);
    public static final UUID NULL_ID = new UUID(0L, 0L);
    private DatabaseManager dbManager;
    private String tableName;
    private final Int2ObjectOpenHashMap<ServerResourceType> typesByHash = new Int2ObjectOpenHashMap();
    private final ArrayList<ServerResourceType> types = new ArrayList();
    private final Object2ObjectOpenHashMap<UUID, ServerResource> resourcesByLID = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<UUID, ServerResource> resourcesByUUID = new Object2ObjectOpenHashMap();
    private Database database;
    private QueryPool globalQueryPool;
    private final ThreadLocal<QueryPool> queryPool = new ThreadLocal();
    protected final ComplexEventBus eventBus = new ComplexEventBus();
    protected final List<ResourceService> services = new ArrayList<ResourceService>();
    protected final Object2ObjectOpenHashMap<Class<?>, ResourceService> servicesByClass = new Object2ObjectOpenHashMap();

    public static UUID getMemoryMapLocalKey(int typeHash, UUID id) {
        return new UUID(id.getMostSignificantBits() ^ (long)typeHash * 31L, id.getLeastSignificantBits());
    }

    public static UUID getMemoryMapLocalKey(ServerResource resource) {
        return ServerResourceManager.getMemoryMapLocalKey(resource.type().idHash, resource.localID());
    }

    public ServerResourceManager() {
        this.eventBus.withDefaultPipelineFactory((bus, eventClass) -> Pipelines.mono(bus));
        this.eventBus.bake(ResourceCreateEvent.class);
        this.eventBus.bake(ResourceUnloadEvent.class);
        this.eventBus.bake(ResourceHandleAcquireEvent.class);
        this.withService(ResourceGCService::new);
    }

    public void setup() {
        this.loadQueryPoolPresets(this.globalQueryPool);
    }

    public ComplexEventBus getEventBus() {
        return this.eventBus;
    }

    public ServerResourceManager withService(ResourceService service) {
        this.services.add(service);
        this.servicesByClass.put(service.getClass(), service);
        service.added();
        return this;
    }

    public <S extends ResourceService> ServerResourceManager withService(Function<ServerResourceManager, S> constructor, BiConsumer<ServerResourceManager, S> consumer) {
        ResourceService service = (ResourceService)constructor.apply((Object)this);
        if (consumer != null) {
            consumer.accept(this, service);
        }
        return this.withService(service);
    }

    public <S extends ResourceService> ServerResourceManager withService(Function<ServerResourceManager, S> constructor) {
        return this.withService(constructor, null);
    }

    public <S extends ResourceService> S serviceByClass(Class<S> sClass) {
        return (S)this.servicesByClass.get(sClass);
    }

    public ServerResourceManager withoutService(ResourceService service) {
        this.services.remove(service);
        this.servicesByClass.remove(service.getClass(), service);
        service.removed();
        return this;
    }

    public ServerResourceManager withoutService(Class<? extends ResourceService> klass) {
        return this.withoutService(this.serviceByClass(klass));
    }

    public ServerResourceManager withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public ServerResourceManager withDatabaseManager(DatabaseManager manager) {
        this.dbManager = manager;
        this.globalQueryPool = manager.queryPool();
        return this;
    }

    public ServerResourceManager database(Database database) {
        if (this.dbManager == null) {
            throw new IllegalStateException("no database manager has been initialized yet");
        }
        this.database = database;
        return this;
    }

    public Database database() {
        return this.database;
    }

    public QueryPool getGlobalQueryPool() {
        return this.globalQueryPool;
    }

    public QueryPool getLocalQueryPool() {
        QueryPool q = this.queryPool.get();
        if (q != null) {
            return q;
        }
        q = this.globalQueryPool.fork();
        this.queryPool.set(q);
        return q;
    }

    public ServerResourceManager registerType(ServerResourceType type) {
        this.types.add(type);
        this.typesByHash.put(type.getIdentifierHash(), type);
        return this;
    }

    public ArrayList<ServerResourceType> getTypes() {
        return this.types;
    }

    public ServerResourceType getType(String id) {
        return this.getType(Identifier.of(id));
    }

    public ServerResourceType getType(Identifier id) {
        return this.getType(id.hashCode());
    }

    public ServerResourceType getType(int hash) {
        return this.typesByHash.get(hash);
    }

    public ServerResourceManager compileResourceClass(Class<? extends ServerResource> klass) {
        try {
            Field field = reflector.reflectDeclaredField(klass, "TYPE");
            ServerResourceType type = (ServerResourceType)reflector.reflectGetField(field, null);
            this.registerType(type);
            return this;
        }
        catch (Exception e) {
            e.printStackTrace(Logging.ERR);
            return this;
        }
    }

    public boolean isLoaded(ServerResource resource) {
        return this.resourcesByUUID.containsKey(resource.universalID());
    }

    public boolean isLoaded(UUID uuid) {
        return this.resourcesByUUID.containsKey(uuid);
    }

    public ServerResourceManager addLoaded(ServerResource resource) {
        this.resourcesByUUID.put(resource.universalID(), resource);
        this.resourcesByLID.put(ServerResourceManager.getMemoryMapLocalKey(resource), resource);
        return this;
    }

    public ServerResourceManager removeLoaded(ServerResource resource) {
        this.resourcesByUUID.remove(resource.universalID());
        this.resourcesByLID.remove(ServerResourceManager.getMemoryMapLocalKey(resource));
        return this;
    }

    public <R extends ServerResource> R getLoadedLocal(ServerResourceType type, UUID id) {
        return (R)this.resourcesByLID.get(ServerResourceManager.getMemoryMapLocalKey(type.idHash, id));
    }

    public <R extends ServerResource> R getLoadedUniversal(UUID uuid) {
        return (R)this.resourcesByUUID.get(uuid);
    }

    public UUID createUniversalID() {
        return new UUID(System.currentTimeMillis(), System.nanoTime());
    }

    public <R extends ServerResource> R createResourceUnwrapped(ServerResourceType<R> type) {
        UUID uuid = this.createUniversalID();
        UUID localId = type.createLocalID();
        R resource = type.newInstanceInternal(uuid, localId);
        this.addLoaded((ServerResource)resource);
        return resource;
    }

    public <R extends ServerResource> ServerResourceHandle<R> createResource(ServerResourceType<R> type) {
        return this.createHandleLoaded(this.createResourceUnwrapped(type));
    }

    public <R extends ServerResource> R loadResourceUnwrapped(UUID uuid) {
        R res = this.getLoadedUniversal(uuid);
        if (res != null) {
            return res;
        }
        DatabaseItem item = this.findDatabaseResource(uuid);
        if (item != null) {
            UUID localId = item.get("localId", UUID.class);
            int typeHash = item.get("type", Integer.class);
            ServerResourceType type = this.getType(typeHash);
            Object resource = type.newInstanceInternal(uuid, localId);
            type.loadResourceSafe(this, item, resource);
            this.addLoaded((ServerResource)resource);
            return resource;
        }
        return null;
    }

    public <R extends ServerResource> ServerResourceHandle<R> loadResource(UUID uuid) {
        return this.createHandleLoaded(this.loadResourceUnwrapped(uuid));
    }

    public <R extends ServerResource> ServerResourceHandle<R> loadResourceLocal(ServerResourceType<R> type, UUID localId) {
        R resource = this.getLoadedLocal(type, localId);
        if (resource != null) {
            return this.createHandleLoaded(resource);
        }
        return this.createHandleLoaded(type.loadResourceLocal(this, localId));
    }

    public <R extends ServerResource> ServerResourceHandle<R> loadDatabaseResourceFiltered(ServerResourceType<R> type, Values eqFilter) {
        DatabaseItem item = this.findDatabaseResourceFiltered(type, eqFilter);
        if (item != null) {
            UUID uuid = item.get("uuid", UUID.class);
            R resource = this.getLoadedUniversal(uuid);
            if (resource == null) {
                resource = type.newInstanceInternal(uuid, item.get("localId", UUID.class));
                this.addLoaded((ServerResource)resource);
                type.loadResourceSafe(this, item, resource);
            }
            return this.createHandleLoaded(resource);
        }
        return null;
    }

    public ServerResourceManager saveResource(ServerResource resource) {
        ServerResourceType type = resource.type();
        type.saveResource(this, resource);
        return this;
    }

    public ServerResourceManager unloadResource(ServerResource resource) {
        this.removeLoaded(resource);
        this.eventBus.post(new ResourceUnloadEvent(this, resource));
        return this;
    }

    public <R extends ServerResource> CompletableFuture<ServerResourceHandle<R>> loadResourceAsync(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> this.loadResource(uuid));
    }

    public <R extends ServerResource> CompletableFuture<ServerResourceHandle<R>> loadResourceLocalAsync(ServerResourceType<R> type, UUID localId) {
        return CompletableFuture.supplyAsync(() -> this.loadResourceLocal(type, localId));
    }

    public CompletableFuture<Void> saveResourceAsync(ServerResource resource) {
        return CompletableFuture.runAsync(() -> this.saveResource(resource));
    }

    public UUID saveResourceReference(ServerResource resource) {
        if (resource == null) {
            return NULL_ID;
        }
        this.saveResourceAsync(resource);
        return resource.universalID();
    }

    public <R extends ServerResource> ServerResourceHandle<R> loadResourceReferenceSync(UUID uuid) {
        if (uuid.equals(NULL_ID)) {
            return null;
        }
        return this.loadResource(uuid);
    }

    public DatabaseItem findDatabaseResource(UUID uuid) {
        QueryPool pool = this.getLocalQueryPool();
        return (DatabaseItem)pool.current((Database)this.requireDatabase()).querySync("find_resource_uuid", new Values().setFlat("uuid", uuid));
    }

    public DatabaseItem findOrCreateDatabaseResource(UUID uuid) {
        DatabaseItem item = this.findDatabaseResource(uuid);
        if (item == null) {
            QueryPool pool = this.getLocalQueryPool();
            item = (DatabaseItem)pool.current((Database)this.requireDatabase()).querySync("create_get_resource_uuid", new Values().setFlat("uuid", uuid));
        }
        return item;
    }

    public DatabaseItem findDatabaseResourceFiltered(ServerResourceType type, Values eqFilter) {
        QueryPool pool = this.getLocalQueryPool();
        DatabaseItem item = (DatabaseItem)pool.current((Database)this.requireDatabase()).querySync("find_resource_filter", new Values().setFlat("typeHash", type.idHash).setFlat("filter", eqFilter));
        return item;
    }

    public <R extends ServerResource> ServerResourceHandle<R> createHandleUniversal(UUID uuid) {
        return new ServerResourceHandle(this, uuid).acquire();
    }

    public <R extends ServerResource> ServerResourceHandle<R> createHandleLoaded(R resource) {
        return new ServerResourceHandle<R>(this, resource).acquire();
    }

    protected void doHandleAcquire(ServerResourceHandle handle) {
        this.eventBus.post(new ResourceHandleAcquireEvent(this, handle));
    }

    protected void doHandleRelease(ServerResourceHandle handle) {
        this.eventBus.post(new ResourceHandleReleaseEvent(this, handle));
    }

    public boolean isDatabaseOpen() {
        return this.database != null && this.database.isOpen();
    }

    public <D extends Database> D requireDatabase() {
        if (!this.isDatabaseOpen()) {
            throw new IllegalStateException("resource database isn't opened");
        }
        return (D)this.database;
    }

    public <D extends Database> D requireDatabase(Class<D> dClass) {
        if (!this.isDatabaseOpen()) {
            throw new IllegalStateException("resource database isn't opened");
        }
        return (D)this.database;
    }

    public String getCollectionName() {
        return this.tableName;
    }

    private MongoCollection<Document> mongoGetOrCreateResCollection(MongoDatabase mongoDatabase) {
        MongoCollection collection = mongoDatabase.getCollection(this.getCollectionName());
        return collection;
    }

    private Bson mongoToFilterEq(Values values) {
        Bson[] bsons = new Bson[values.getSize()];
        int i = 0;
        for (Map.Entry<Object, Object> entry : values.entrySet()) {
            bsons[i++] = Filters.eq((String)((String)entry.getKey()), (Object)entry.getValue());
        }
        return Filters.and((Bson[])bsons);
    }

    private void loadQueryPoolPresets(QueryPool pool) {
        pool.putQuery("find_resource_uuid", DatabaseType.MONGO_DB, (query, database, values) -> {
            MongoCollection<Document> collection = this.mongoGetOrCreateResCollection(database.getDatabaseClient());
            UUID uuid = (UUID)values.getFlat("uuid");
            Document doc = (Document)collection.find(Filters.and((Bson[])new Bson[]{Projections.excludeId(), Filters.eq((String)"uuid", values.getFlat("uuid"))})).projection(Projections.excludeId()).first();
            if (doc != null) {
                return new MongoDatabaseItem((Database)database, "uuid", collection, uuid).pull();
            }
            return null;
        });
        pool.putQuery("find_resource_local", DatabaseType.MONGO_DB, (query, database, values) -> {
            MongoCollection<Document> collection = this.mongoGetOrCreateResCollection(database.getDatabaseClient());
            Document doc = (Document)collection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"localId", values.getFlat("localId")), Filters.eq((String)"type", values.getFlat("typeHash"))})).projection(Projections.excludeId()).first();
            if (doc != null) {
                return new MongoDatabaseItem((Database)database, "uuid", collection, doc.get((Object)"uuid", UUID.class)).pull();
            }
            return null;
        });
        pool.putQuery("find_resource_filter", DatabaseType.MONGO_DB, (query, database, values) -> {
            MongoCollection<Document> collection = this.mongoGetOrCreateResCollection(database.getDatabaseClient());
            Document doc = (Document)collection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"type", values.getFlat("typeHash")), this.mongoToFilterEq((Values)values.getFlat("filter"))})).projection(Projections.excludeId()).first();
            if (doc != null) {
                return new MongoDatabaseItem((Database)database, "uuid", collection, doc.get((Object)"uuid", UUID.class)).pull();
            }
            return null;
        });
        pool.putQuery("create_get_resource_uuid", DatabaseType.MONGO_DB, (query, database, values) -> {
            MongoCollection<Document> collection = this.mongoGetOrCreateResCollection(database.getDatabaseClient());
            Document document = new Document();
            UUID uuid = (UUID)values.getFlat("uuid");
            document.put("uuid", (Object)uuid);
            collection.insertOne((Object)document);
            return new MongoDatabaseItem((Database)database, "uuid", collection, uuid).pull();
        });
    }
}

