/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.resource;

import java.lang.reflect.Constructor;
import java.lang.reflect.InaccessibleObjectException;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.functional.TriFunction;
import net.orbyfied.osf.db.Database;
import net.orbyfied.osf.db.DatabaseItem;
import net.orbyfied.osf.db.QueryPool;
import net.orbyfied.osf.resource.ServerResource;
import net.orbyfied.osf.resource.ServerResourceManager;
import net.orbyfied.osf.util.Values;
import net.orbyfied.osf.util.logging.EventLog;
import net.orbyfied.osf.util.logging.Logging;

public abstract class ServerResourceType<R extends ServerResource> {
    protected static final EventLog LOGGER = Logging.getEventLog("ServerResource");
    protected static final Random RANDOM = new Random(System.currentTimeMillis() ^ System.nanoTime());
    final Identifier id;
    final int idHash;
    Class<R> resourceClass;
    Constructor<R> constructor;
    final Values props = new Values();

    public static <R extends ServerResource> ServerResourceType<R> ofChronoIds(Class<R> rClass, Identifier id, final TriFunction<ServerResourceManager, DatabaseItem, R, ResourceSaveResult> saveR, final TriFunction<ServerResourceManager, DatabaseItem, R, ResourceLoadResult> loadR) {
        return new ServerResourceType<R>(id, rClass){

            @Override
            public UUID createLocalID() {
                return new UUID(System.currentTimeMillis() * (long)this.idHash, System.nanoTime());
            }

            @Override
            public ResourceSaveResult saveResource(ServerResourceManager manager, DatabaseItem dbItem, R resource) {
                return (ResourceSaveResult)saveR.apply(manager, dbItem, resource);
            }

            @Override
            public ResourceLoadResult loadResource(ServerResourceManager manager, DatabaseItem dbItem, R resource) {
                return (ResourceLoadResult)loadR.apply(manager, dbItem, resource);
            }
        };
    }

    public static <R extends ServerResource> ServerResourceType<R> ofChronoIds(Class<R> rClass, String id, TriFunction<ServerResourceManager, DatabaseItem, R, ResourceSaveResult> saveR, TriFunction<ServerResourceManager, DatabaseItem, R, ResourceLoadResult> loadR) {
        return ServerResourceType.ofChronoIds(rClass, Identifier.of(id), saveR, loadR);
    }

    public ServerResourceType(Identifier id, Class<R> resourceClass) {
        this.id = id;
        this.idHash = id.hashCode();
        this.resourceClass = resourceClass;
        try {
            try {
                this.constructor = resourceClass.getDeclaredConstructor(UUID.class, UUID.class);
            }
            catch (NoSuchMethodException e) {
                this.constructor = resourceClass.getDeclaredConstructor(UUID.class, ServerResourceType.class, UUID.class);
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.newErr("invalid_type", "No constructor (UUID, UUID) for resource type " + id + " (" + resourceClass.getName() + ")", new Object[0]).extra(v -> v.put("type", resourceClass)).push();
        }
        catch (InaccessibleObjectException e) {
            LOGGER.newErr("invalid_type", "Unable to access constructor (UUID, UUID) for resource type " + id + " (" + resourceClass.getName() + ")", new Object[0]).extra(v -> v.put("type", resourceClass)).push();
            e.printStackTrace(Logging.ERR);
        }
        catch (Exception e) {
            LOGGER.newErr("invalid_type", "Failed to get constructor (UUID, UUID) for resource type " + id + " (" + resourceClass.getName() + ")", new Object[0]).extra(v -> v.put("type", resourceClass)).push();
            e.printStackTrace(Logging.ERR);
        }
    }

    public Identifier getIdentifier() {
        return this.id;
    }

    public int getIdentifierHash() {
        return this.idHash;
    }

    public Class<R> getResourceClass() {
        return this.resourceClass;
    }

    public Values properties() {
        return this.props;
    }

    public ServerResourceType<R> properties(BiConsumer<ServerResourceType<R>, Values> consumer) {
        consumer.accept(this, this.props);
        return this;
    }

    public abstract UUID createLocalID();

    public R newInstanceInternal(UUID uuid, UUID localId) {
        try {
            if (this.constructor.getParameterCount() == 2) {
                return (R)((ServerResource)this.constructor.newInstance(uuid, localId));
            }
            return (R)((ServerResource)this.constructor.newInstance(uuid, this, localId));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public R loadResourceLocal(ServerResourceManager manager, UUID localId) {
        DatabaseItem item = this.findDatabaseResourceLocal(manager, (Database)manager.requireDatabase(), localId);
        if (item != null) {
            UUID uuid = item.get("uuid", UUID.class);
            R resource = this.newInstanceInternal(uuid, localId);
            this.loadResourceSafe(manager, item, resource);
            manager.addLoaded((ServerResource)resource);
            return resource;
        }
        return null;
    }

    public ServerResourceType<R> saveResource(ServerResourceManager manager, ServerResource resource) {
        DatabaseItem item = manager.findOrCreateDatabaseResource(resource.universalID());
        item.set("uuid", resource.universalID());
        item.set("localId", resource.localID());
        item.set("type", this.getIdentifierHash());
        this.saveResourceSafe(manager, item, resource);
        return this;
    }

    public DatabaseItem findDatabaseResource(ServerResourceManager manager, UUID uuid) {
        return manager.findDatabaseResource(uuid);
    }

    public DatabaseItem findDatabaseResourceLocal(ServerResourceManager manager, Database database, UUID localId) {
        QueryPool pool = manager.getLocalQueryPool();
        return (DatabaseItem)pool.current(database).querySync("find_resource_local", new Values().setFlat("localId", localId).setFlat("typeHash", this.getIdentifierHash()));
    }

    public abstract ResourceSaveResult saveResource(ServerResourceManager var1, DatabaseItem var2, R var3);

    public abstract ResourceLoadResult loadResource(ServerResourceManager var1, DatabaseItem var2, R var3);

    public ResourceSaveResult saveResourceSafe(ServerResourceManager manager, DatabaseItem dbItem, R resource) {
        EventLog logger = ServerResourceManager.LOGGER;
        try {
            ResourceSaveResult result = this.saveResource(manager, dbItem, resource);
            if (result.success()) {
                dbItem.push();
            }
            return result;
        }
        catch (Exception e) {
            logger.newErr("resource save", e, "Error while saving resource " + ((ServerResource)resource).universalID() + " of type " + ((ServerResource)resource).type().id, new Object[0]).extra(v -> v.put("resource_id", resource.universalID())).push();
            return new ResourceSaveResult(false, e);
        }
    }

    public ResourceLoadResult loadResourceSafe(ServerResourceManager manager, DatabaseItem dbItem, R resource) {
        EventLog logger = ServerResourceManager.LOGGER;
        try {
            dbItem.pull();
            return this.loadResource(manager, dbItem, resource);
        }
        catch (Exception e) {
            logger.newErr("resource_load", e, "Error while loading resource " + ((ServerResource)resource).universalID() + " of type " + ((ServerResource)resource).type().id, new Object[0]).push();
            return new ResourceLoadResult(false, e);
        }
    }

    public record ResourceLoadResult(boolean success, Throwable t) {
        public static ResourceLoadResult ofSuccess() {
            return new ResourceLoadResult(true, null);
        }
    }

    public record ResourceSaveResult(boolean success, Throwable t) {
        public static ResourceSaveResult ofSuccess() {
            return new ResourceSaveResult(true, null);
        }
    }
}

