/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.resource.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.orbyfied.j8.event.handler.BasicHandler;
import net.orbyfied.j8.util.functional.ThrowableRunnable;
import net.orbyfied.osf.resource.AbstractResourceService;
import net.orbyfied.osf.resource.ServerResource;
import net.orbyfied.osf.resource.ServerResourceManager;
import net.orbyfied.osf.resource.event.ResourceHandleAcquireEvent;
import net.orbyfied.osf.resource.event.ResourceHandleReleaseEvent;
import net.orbyfied.osf.resource.event.ResourceUnloadEvent;
import net.orbyfied.osf.util.data.IntBox;
import net.orbyfied.osf.util.worker.SafeWorker;

public class ResourceGCService
extends AbstractResourceService {
    public static final Object PERSISTENT = new Object();
    boolean automate = true;
    final ConcurrentHashMap<ServerResource, IntBox> usages = new ConcurrentHashMap();
    final Queue<ServerResource> queue = new ArrayDeque<ServerResource>();
    final SafeWorker worker = new SafeWorker();
    final AtomicBoolean waiting = new AtomicBoolean(false);

    public ResourceGCService(ServerResourceManager manager) {
        super(manager);
        this.worker.withTarget(new WorkerTarget());
    }

    public SafeWorker worker() {
        return this.worker;
    }

    @Override
    public void added() {
        super.added();
        this.worker.commence();
    }

    @Override
    public void removed() {
        super.removed();
        this.worker.terminate();
    }

    public void disposeImmediate(ServerResource resource) {
        if (resource.type().properties().getOrDefaultFlat(PERSISTENT, true).booleanValue()) {
            this.manager.saveResource(resource);
        }
        this.manager.unloadResource(resource);
    }

    public void acquireImmediate(ServerResource resource) {
        IntBox u = this.usages.get(resource);
        if (u == null) {
            u = new IntBox();
            this.usages.put(resource, u);
        }
        ++u.value;
    }

    public void releaseImmediate(ServerResource resource) {
        IntBox u = this.usages.get(resource);
        boolean dispose = false;
        if (u != null) {
            --u.value;
            if (u.value <= 0) {
                dispose = true;
            }
        } else {
            dispose = true;
        }
        if (dispose) {
            this.disposeImmediate(resource);
        }
    }

    @BasicHandler
    void handleUnloaded(ResourceUnloadEvent event) {
        this.usages.remove(event.getResource());
    }

    @BasicHandler
    void handleReleased(ResourceHandleReleaseEvent event) {
        if (!this.automate) {
            return;
        }
        Object resource = event.getHandle().getOrNull();
        if (resource == null) {
            return;
        }
        this.releaseImmediate((ServerResource)resource);
    }

    @BasicHandler
    void handleAcquired(ResourceHandleAcquireEvent event) {
        if (!this.automate) {
            return;
        }
        Object resource = event.getHandle().getOrNull();
        if (resource == null) {
            return;
        }
        this.acquireImmediate((ServerResource)resource);
    }

    class WorkerTarget
    implements ThrowableRunnable {
        WorkerTarget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws Throwable {
            while (ResourceGCService.this.worker.shouldRun()) {
                if (ResourceGCService.this.queue.isEmpty()) {
                    Queue<ServerResource> queue = ResourceGCService.this.queue;
                    synchronized (queue) {
                        ResourceGCService.this.waiting.set(true);
                        ResourceGCService.this.queue.wait();
                    }
                    ResourceGCService.this.waiting.set(false);
                }
                ArrayList<ServerResource> resources = new ArrayList<ServerResource>(ResourceGCService.this.queue.size());
                Queue<ServerResource> queue = ResourceGCService.this.queue;
                synchronized (queue) {
                    while (!ResourceGCService.this.queue.isEmpty()) {
                        resources.add(ResourceGCService.this.queue.poll());
                    }
                }
                for (ServerResource resource : resources) {
                    ResourceGCService.this.disposeImmediate(resource);
                }
            }
        }
    }
}

