/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.server;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.orbyfied.j8.event.BusEvent;
import net.orbyfied.j8.event.ComplexEventBus;
import net.orbyfied.j8.event.EventListener;
import net.orbyfied.j8.event.pipeline.impl.BasicPipeline;
import net.orbyfied.j8.event.util.Pipelines;
import net.orbyfied.osf.db.DatabaseManager;
import net.orbyfied.osf.network.NetworkManager;
import net.orbyfied.osf.network.handler.ChainAction;
import net.orbyfied.osf.network.handler.HandlerResult;
import net.orbyfied.osf.network.handler.NodeAction;
import net.orbyfied.osf.network.handler.UtilityNetworkHandler;
import net.orbyfied.osf.resource.ServerResourceManager;
import net.orbyfied.osf.server.ProtocolSpecification;
import net.orbyfied.osf.server.ServerClient;
import net.orbyfied.osf.server.ServerClientList;
import net.orbyfied.osf.server.common.GeneralProtocolSpec;
import net.orbyfied.osf.server.common.HandshakeProtocolSpec;
import net.orbyfied.osf.server.common.protocol.general.PacketUnboundDisconnect;
import net.orbyfied.osf.server.event.ServerClientConnectEvent;
import net.orbyfied.osf.server.event.ServerPostStartEvent;
import net.orbyfied.osf.server.event.ServerPrepareEvent;
import net.orbyfied.osf.server.event.ServerStopEvent;
import net.orbyfied.osf.server.exception.ClientConnectException;
import net.orbyfied.osf.server.exception.ServerInitializeException;
import net.orbyfied.osf.util.Values;
import net.orbyfied.osf.util.Version;
import net.orbyfied.osf.util.logging.EventLog;
import net.orbyfied.osf.util.logging.Logging;
import net.orbyfied.osf.util.security.AsymmetricEncryptionProfile;
import net.orbyfied.osf.util.worker.SafeWorker;

public abstract class Server
implements EventListener {
    protected static final EventLog logger = Logging.getEventLog("Server");
    public static final Object K_ENABLE_ENCRYPTED = new Object();
    public static final Object K_ENFORCE_ENCRYPTED = new Object();
    private final String name;
    private final Version version;
    protected final Values configuration = new Values();
    protected final NetworkManager networkManager;
    protected final DatabaseManager databaseManager;
    protected final ServerResourceManager resourceManager;
    protected final List<ProtocolSpecification> protocolSpecifications = new ArrayList<ProtocolSpecification>();
    protected ServerSocket serverSocket;
    protected UtilityNetworkHandler utilityNetworkHandler;
    protected AsymmetricEncryptionProfile rsaEncryptionProfile;
    protected Function<Server, ServerClientList> clientListFactory = ServerClientList::new;
    protected BiFunction<Server, Socket, ServerClient> clientInstanceFactory = (server, socket) -> new ServerClient(this, (Socket)socket);
    private ServerClientList clients;
    private final ComplexEventBus eventBus = new ComplexEventBus();
    private AtomicBoolean active;
    private SafeWorker serverSocketWorker;

    public Server(String name, Version version) {
        this.name = name;
        this.version = version;
        try {
            logger.info("init_core_services", "Initializing core services", new Object[0]);
            this.networkManager = new NetworkManager();
            this.databaseManager = new DatabaseManager();
            this.resourceManager = new ServerResourceManager().withTableName(name + "-resources").withDatabaseManager(this.databaseManager);
        }
        catch (Exception e) {
            throw new ServerInitializeException("Exception in instantiation", e);
        }
        this.eventBus.withDefaultPipelineFactory((bus, eventClass) -> Pipelines.mono(bus));
        this.eventBus.register(this);
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public NetworkManager networkManager() {
        return this.networkManager;
    }

    public DatabaseManager databaseManager() {
        return this.databaseManager;
    }

    public ServerResourceManager resourceManager() {
        return this.resourceManager;
    }

    public UtilityNetworkHandler utilityNetworkHandler() {
        return this.utilityNetworkHandler;
    }

    public ComplexEventBus eventBus() {
        return this.eventBus;
    }

    public <E extends BusEvent> void on(Class<E> eClass, Consumer<E> consumer) {
        ((BasicPipeline)this.eventBus.getPipelineFor(eClass).base()).addLast(consumer::accept);
    }

    public Server setActive(boolean b) {
        this.active.set(b);
        return this;
    }

    public SafeWorker serverSocketWorker() {
        return this.serverSocketWorker;
    }

    public ServerClientList clients() {
        return this.clients;
    }

    public Server stop() {
        this.active.set(false);
        this.eventBus.post(new ServerStopEvent(this));
        return this;
    }

    public Server prepare() {
        this.eventBus.post(new ServerPrepareEvent(this));
        this.resourceManager.setup();
        this.clients = this.clientListFactory.apply(this);
        return this;
    }

    public Server open(SocketAddress address) {
        logger.stage("Connect");
        this.protocolSpecifications.add(GeneralProtocolSpec.INSTANCE);
        if (this.configuration.getOrDefaultFlat(K_ENABLE_ENCRYPTED, true).booleanValue()) {
            this.protocolSpecifications.add(HandshakeProtocolSpec.INSTANCE);
        }
        for (ProtocolSpecification spec : this.protocolSpecifications) {
            spec.apply(this.networkManager);
        }
        logger.newOk("load_protocol", "Loaded protocol consisting of " + this.protocolSpecifications.size() + " specifications", new Object[0]).extra(v -> v.put("specs", this.protocolSpecifications)).push();
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(address);
            logger.ok("server_socket_connect", "Connected server socket on {0}", address);
        }
        catch (Exception e) {
            logger.err("server_socket_connect", "Error while binding server socket to {0}", address);
            throw new ServerInitializeException("Connect: error while binding socket", e);
        }
        this.utilityNetworkHandler = (UtilityNetworkHandler)new UtilityNetworkHandler(this.networkManager, null).owned(this);
        this.utilityNetworkHandler.start();
        if (this.configuration.getOrDefaultFlat(K_ENABLE_ENCRYPTED, true).booleanValue()) {
            try {
                this.rsaEncryptionProfile = GeneralProtocolSpec.newAsymmetricEncryptionProfile();
                this.rsaEncryptionProfile.generateKeys();
            }
            catch (Exception e) {
                logger.err("rsa_encryption", e, "Failed to enable RSA encryption", new Object[0]);
                throw new ServerInitializeException("Connect: error while enabling RSA encryption", e);
            }
        }
        logger.stage(null);
        return this;
    }

    public Server start() {
        this.eventBus.post(new ServerPostStartEvent(this));
        logger.info("server_socket_worker", "Activating server socket", new Object[0]);
        this.serverSocketWorker = new SafeWorker().withErrorHandler((safeWorker, throwable) -> {
            logger.err("server_socket_worker", "Error in server socket worker, shutting down", new Object[0]);
            throwable.printStackTrace();
            this.stop();
        }).withTarget(this::mainServerSocketLoop).withActivityPredicate(safeWorker -> this.active.get()).commence();
        return this;
    }

    private void mainServerSocketLoop() {
        logger.stage("Socket");
        while (!this.serverSocket.isClosed()) {
            Socket clientSocket;
            try {
                clientSocket = this.serverSocket.accept();
            }
            catch (Exception e) {
                logger.err("server_socket_accept", e, "Error while accepting connections", new Object[0]);
                e.printStackTrace();
                continue;
            }
            try {
                ServerClient client = this.clientInstanceFactory.apply(this, clientSocket);
                this.clients.add(client);
                client.start();
                client.networkHandler().node().childForType(PacketUnboundDisconnect.TYPE).withHandler((handler, node, packet) -> {
                    logger.info("client_disconnect", "Client {0} disconnected with message '" + packet.getMessage() + "'", client);
                    client.destroy();
                    return new HandlerResult(ChainAction.CONTINUE).nodeAction(NodeAction.REMOVE);
                });
                if (this.configuration.getOrDefaultFlat(K_ENABLE_ENCRYPTED, true).booleanValue()) {
                    client.initSymmetricEncryptionHandshake();
                } else {
                    client.initRefuseSymmetricEncryptionHandshake();
                }
                this.eventBus.post(new ServerClientConnectEvent(this, client));
            }
            catch (ClientConnectException e) {
                if ("connect".equals(e.getMessage())) {
                    logger.err("client_connect", e, "Error connecting new client to socket {0}", ServerClient.formatSocketAddress(clientSocket));
                    continue;
                }
                logger.err("client_connect", e, "Unknown error while connecting new client to socket {0}", ServerClient.formatSocketAddress(clientSocket));
            }
            catch (Exception e) {
                logger.err("client_connect", e, "Error while accepting client from {0}", ServerClient.formatSocketAddress(clientSocket));
                e.printStackTrace();
            }
        }
    }
}

