/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.server;

import java.net.Socket;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import net.orbyfied.osf.network.handler.ChainAction;
import net.orbyfied.osf.network.handler.HandlerResult;
import net.orbyfied.osf.network.handler.NodeAction;
import net.orbyfied.osf.network.handler.SocketNetworkHandler;
import net.orbyfied.osf.server.Server;
import net.orbyfied.osf.server.common.GeneralProtocolSpec;
import net.orbyfied.osf.server.common.protocol.general.PacketUnboundDisconnect;
import net.orbyfied.osf.server.common.protocol.handshake.PacketClientboundPubKey;
import net.orbyfied.osf.server.common.protocol.handshake.PacketServerboundClientKey;
import net.orbyfied.osf.server.common.protocol.handshake.PacketUnboundHandshakeStop;
import net.orbyfied.osf.server.common.protocol.handshake.PacketUnboundVerifyEncryption;
import net.orbyfied.osf.server.event.ServerClientReadyEvent;
import net.orbyfied.osf.server.exception.ClientConnectException;
import net.orbyfied.osf.util.logging.EventLog;
import net.orbyfied.osf.util.logging.Logging;
import net.orbyfied.osf.util.security.SymmetricEncryptionProfile;

public class ServerClient {
    protected static final EventLog log = Logging.getEventLog("ServerClient");
    private final Server server;
    private final SocketNetworkHandler networkHandler;
    private boolean active;
    private final HashSet<String> readyJobs = new HashSet();
    protected SymmetricEncryptionProfile clientSymmetricEncryption;

    public static String formatSocketAddress(Socket socket) {
        return socket.getInetAddress() + ":" + socket.getPort();
    }

    public ServerClient(Server server, Socket socket) {
        this.server = server;
        boolean encrypt = server.configuration.getOrDefaultFlat(Server.K_ENABLE_ENCRYPTED, true);
        this.networkHandler = new SocketNetworkHandler(server.networkManager(), server.utilityNetworkHandler()).autoEncrypt(encrypt);
        if (encrypt) {
            this.clientSymmetricEncryption = GeneralProtocolSpec.newSymmetricEncryptionProfile();
        }
        try {
            this.networkHandler.connect(socket);
        }
        catch (Exception e) {
            throw new ClientConnectException("connect", e);
        }
    }

    public SocketNetworkHandler networkHandler() {
        return this.networkHandler;
    }

    public Server server() {
        return this.server;
    }

    public boolean isActive() {
        return this.active;
    }

    public ServerClient start() {
        this.networkHandler.start();
        return this;
    }

    public ServerClient stop() {
        if (this.networkHandler.isOpen()) {
            this.networkHandler.disconnect();
        }
        if (this.networkHandler.active()) {
            this.networkHandler.stop();
        }
        return this;
    }

    public ServerClient disconnectWithMessage(String message) {
        this.networkHandler.sendSync(new PacketUnboundDisconnect(message));
        this.networkHandler.disconnect();
        this.networkHandler.stop();
        return this;
    }

    public ServerClient destroy() {
        if (this.networkHandler.isOpen()) {
            this.networkHandler.disconnect();
        }
        if (this.isActive()) {
            this.stop();
        }
        this.server.clients().remove(this);
        return this;
    }

    protected void readyClient() {
        this.server.eventBus().post(new ServerClientReadyEvent(this.server, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishReadyJob(String job) {
        int len;
        HashSet<String> hashSet = this.readyJobs;
        synchronized (hashSet) {
            this.readyJobs.remove(job);
            len = this.readyJobs.size();
        }
        if (len == 0) {
            this.readyClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postReadyJob(String job) {
        HashSet<String> hashSet = this.readyJobs;
        synchronized (hashSet) {
            this.readyJobs.add(job);
        }
    }

    public SymmetricEncryptionProfile getClientSymmetricEncryption() {
        return this.clientSymmetricEncryption;
    }

    protected void initRefuseSymmetricEncryptionHandshake() {
        this.networkHandler.sendSync(new PacketUnboundHandshakeStop("Disabled"));
    }

    protected void initSymmetricEncryptionHandshake() {
        this.postReadyJob("encryption-handshake");
        AtomicReference okMessage = new AtomicReference();
        this.networkHandler.node().childForType(PacketServerboundClientKey.TYPE).withHandler((handler, node, packet) -> {
            this.clientSymmetricEncryption.withKey("secret", packet.getKey());
            this.networkHandler.withEncryptionProfile(this.clientSymmetricEncryption);
            return new HandlerResult(ChainAction.CONTINUE).nodeAction(NodeAction.REMOVE);
        });
        this.networkHandler.node().childForType(PacketUnboundVerifyEncryption.TYPE).withHandler((handler, node, packet) -> {
            if (packet.getMessage().equals((String)okMessage.get() + "-modified")) {
                log.ok("verify_encryption", "Established and verified AES encrypted connection for {0}", this);
                this.finishReadyJob("encryption-handshake");
            } else {
                log.warn("verify_encryption", "AES verification failed for {0}", this);
                if (this.server.configuration.getOrDefaultFlat(Server.K_ENFORCE_ENCRYPTED, true).booleanValue()) {
                    this.disconnectWithMessage("Encryption required");
                } else {
                    this.finishReadyJob("encryption-handshake");
                }
            }
            return new HandlerResult(ChainAction.CONTINUE).nodeAction(NodeAction.REMOVE);
        });
        this.networkHandler.withEncryptionProfile(this.server.rsaEncryptionProfile).sendSync(new PacketClientboundPubKey(this.server.rsaEncryptionProfile.getPublicKey()));
    }

    public String toString() {
        Object str = "ServerClient[";
        if (this.networkHandler != null && this.networkHandler.isOpen()) {
            str = (String)str + ServerClient.formatSocketAddress(this.networkHandler.getSocket());
        }
        return (String)str + "]";
    }
}

