/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.server;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.orbyfied.osf.server.Server;
import net.orbyfied.osf.server.ServerClient;

public class ServerClientList {
    private final Server server;
    protected final List<ServerClient> clients = new ArrayList<ServerClient>();
    protected final Map<SocketAddress, ServerClient> clientsByAddr = new HashMap<SocketAddress, ServerClient>();

    public ServerClientList(Server server) {
        this.server = server;
    }

    public Server server() {
        return this.server;
    }

    public ServerClientList add(ServerClient client) {
        this.clients.add(client);
        this.clientsByAddr.put(client.networkHandler().getSocket().getRemoteSocketAddress(), client);
        return this;
    }

    public ServerClientList remove(ServerClient client) {
        this.clients.remove(client);
        this.clientsByAddr.remove(client.networkHandler().getSocket().getRemoteSocketAddress(), client);
        return this;
    }

    public List<ServerClient> list() {
        return Collections.unmodifiableList(this.clients);
    }
}

