/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.orbyfied.osf.util.Strings;

public class Values {
    Object2ObjectOpenHashMap<Object, Object> map;

    public static Values ofVarargs(Values values, Object ... objs) {
        String key = null;
        int l = objs.length;
        for (int i = 0; i < l; ++i) {
            Object obj = objs[i];
            if (i % 2 == 0) {
                key = (String)obj;
                continue;
            }
            values.put(key, obj);
            key = null;
        }
        return values;
    }

    public static Values ofVarargs(Object ... objs) {
        return Values.ofVarargs(new Values(), objs);
    }

    public Values() {
        this.map = new Object2ObjectOpenHashMap();
    }

    public Values(int size) {
        this.map = new Object2ObjectOpenHashMap(size);
    }

    public Values(Object ... objs) {
        this.map = new Object2ObjectOpenHashMap(objs.length);
        Values.ofVarargs(this, objs);
    }

    public Values(Object2ObjectOpenHashMap<Object, Object> map) {
        this.map = map;
    }

    public Values(Map<String, Object> map) {
        this.map = new Object2ObjectOpenHashMap();
        this.map.putAll(map);
    }

    public int getSize() {
        return this.map.size();
    }

    public Object2ObjectOpenHashMap<Object, Object> getMap() {
        return this.map;
    }

    public Values putAll(Values values) {
        this.map.putAll(values.getMap());
        return this;
    }

    public Values putAll(Map map) {
        this.map.putAll(map);
        return this;
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    public List<Map.Entry<Object, Object>> entries() {
        return new ArrayList<Map.Entry<Object, Object>>(this.map.entrySet());
    }

    public Set<Object> keySet() {
        return this.map.keySet();
    }

    public List<Object> keys() {
        return new ArrayList<Object>(this.map.keySet());
    }

    public Collection<Object> valueCollection() {
        return this.map.values();
    }

    public List<Object> values() {
        return new ArrayList<Object>(this.map.values());
    }

    public Values setFlat(Object key, Object val) {
        if (val == this) {
            throw new IllegalArgumentException("cannot put this recursively, attempted under key '" + key + "'");
        }
        this.map.put(key, val);
        return this;
    }

    public Values set(String key, Object val) {
        if (val == this) {
            throw new IllegalArgumentException("cannot put this recursively, attempted under key '" + key + "'");
        }
        String[] path = key.split("\\.");
        if (path.length == 0) {
            throw new IllegalArgumentException("invalid key: '" + key + "'");
        }
        Object f = this.traversePath(path);
        this.assignObject(f, this.last(path), val);
        return this;
    }

    public Values put(Object key, Object val) {
        return this.setFlat(key, val);
    }

    public <V> V get(String key) {
        String[] path = key.split("\\.");
        if (path.length == 0) {
            throw new IllegalArgumentException("invalid key: '" + key + "'");
        }
        Object f = this.traversePath(path);
        return (V)this.indexObject(f, this.last(path));
    }

    public <V> V get(String key, Class<V> vClass) {
        String[] path = key.split("\\.");
        if (path.length == 0) {
            throw new IllegalArgumentException("invalid key: '" + key + "'");
        }
        String pl = this.last(path);
        Object f = this.traversePath(path);
        Object v = this.indexObject(f, pl);
        if (v instanceof Map) {
            Map map = (Map)v;
            if (vClass == Values.class) {
                v = new Values(map);
                this.assignObject(f, pl, v);
            }
        }
        return (V)v;
    }

    public <V> V getFlat(Object key) {
        return (V)this.map.get(key);
    }

    public <V> V getFlat(Object key, Class<V> vClass) {
        return this.getFlat(key);
    }

    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    public <V> V getOrDefaultFlat(Object key, V def) {
        if (!this.map.containsKey(key)) {
            return def;
        }
        return (V)this.map.get(key);
    }

    public <V> V getOrDefault(String key, V def) {
        String[] path = key.split("\\.");
        if (path.length == 0) {
            throw new IllegalArgumentException("invalid key: '" + key + "'");
        }
        Object f = this.traversePath(path);
        if (!this.hasObject(f, this.last(path))) {
            return def;
        }
        return (V)this.indexObject(f, this.last(path));
    }

    public <V> V getOrDefault(String key, Class<V> vClass, V def) {
        return this.getOrDefault(key, def);
    }

    boolean hasObject(Object obj, String key) {
        if (obj instanceof Values) {
            Values v = (Values)obj;
            return v.contains(key);
        }
        if (obj instanceof Map) {
            Map m = (Map)obj;
            return m.containsKey(key);
        }
        throw new IllegalArgumentException("object of type " + (obj == null ? "null" : obj.getClass().getName()) + " is not indexable by string");
    }

    void assignObject(Object obj, String key, Object val) {
        if (obj instanceof Values) {
            Values v = (Values)obj;
            v.setFlat(key, val);
            return;
        }
        if (obj instanceof Map) {
            Map m = (Map)obj;
            m.put(key, val);
            return;
        }
        throw new IllegalArgumentException("object of type " + (obj == null ? "null" : obj.getClass().getName()) + " is not indexable by string");
    }

    Object indexObject(Object obj, String key) {
        if (obj instanceof Values) {
            Values v = (Values)obj;
            return v.getFlat(key);
        }
        if (obj instanceof Map) {
            Map m = (Map)obj;
            return m.get(key);
        }
        throw new IllegalArgumentException("object of type " + (obj == null ? "null" : obj.getClass().getName()) + " is not indexable by string");
    }

    Object traversePath(String[] path) {
        Object curr = this;
        int l = path.length - 1;
        for (int i = 0; i < l; ++i) {
            curr = this.indexObject(curr, path[i]);
        }
        return curr;
    }

    private <V> V last(V[] vs) {
        if (vs.length == 0) {
            throw new IllegalArgumentException("invalid array of size 0");
        }
        return vs[vs.length - 1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Values values = (Values)o;
        return Objects.equals(this.map, values.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("{ ");
        int i = 0;
        for (Map.Entry entry : this.map.entrySet()) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(Strings.toStringPretty(entry.getKey()));
            b.append(" : ");
            b.append(Strings.toStringPretty(entry.getValue()));
            ++i;
        }
        return b.append(" }").toString();
    }
}

