/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.util;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public class Version {
    public static final BiFunction<Integer, Integer, Integer> MAJORS_GREATER = (a, b) -> {
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    };
    public static final BiFunction<Integer, Integer, Integer> MAJORS_LESS = (a, b) -> {
        if (a < b) {
            return 1;
        }
        if (a > b) {
            return -1;
        }
        return 0;
    };
    public static final BiFunction<Integer, Integer, Integer> MAJORS_EQUAL = (a, b) -> a.equals(b) ? 1 : -1;
    private int major;
    private int minor;
    private float patch;

    public static Version of(String s) {
        StringBuilder b = new StringBuilder();
        String[] components = new String[3];
        int ci = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '.' && ci != 2) {
                components[ci++] = b.toString();
                continue;
            }
            b.append(c);
        }
        if (ci == 2) {
            components[2] = b.toString();
        } else if (ci < 2) {
            throw new MalformedVersionException("for input string: " + s);
        }
        try {
            int major = Integer.parseInt(components[0]);
            int minor = Integer.parseInt(components[1]);
            float patch = 0.0f;
            if (components[2] != null) {
                patch = Float.parseFloat(components[2]);
            }
            return new Version(major, minor, patch);
        }
        catch (NullPointerException | NumberFormatException e) {
            throw new MalformedVersionException("for input string: " + s);
        }
    }

    public static Version readFromResource(Class<?> ref, String path) {
        try {
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            InputStream is = ref.getResourceAsStream((String)path);
            Version ver = Version.of(new String(is.readAllBytes(), StandardCharsets.UTF_8));
            is.close();
            return ver;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String patchToString(float patch) {
        if (patch % 1.0f == 0.0f) {
            return Integer.toString((int)patch);
        }
        return Float.toString(patch);
    }

    public Version(int major, int minor, float patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public float getPatch() {
        return this.patch;
    }

    public boolean compareStatement(Version with, BiFunction<Integer, Integer, Integer> aComparator, BiPredicate<Float, Float> patchComparator) {
        int c = aComparator.apply(this.major, with.major);
        if (c == 1) {
            return true;
        }
        if (c == -1) {
            return false;
        }
        c = aComparator.apply(this.minor, with.minor);
        if (c == 1) {
            return true;
        }
        if (c == -1) {
            return false;
        }
        return patchComparator.test(Float.valueOf(this.patch), Float.valueOf(with.patch));
    }

    public boolean isGreater(Version v) {
        return this.compareStatement(v, MAJORS_GREATER, (a, b) -> a.floatValue() > b.floatValue());
    }

    public boolean isGreaterOrEqual(Version v) {
        return this.compareStatement(v, MAJORS_GREATER, (a, b) -> a.floatValue() >= b.floatValue());
    }

    public boolean isLower(Version v) {
        return this.compareStatement(v, MAJORS_LESS, (a, b) -> a.floatValue() < b.floatValue());
    }

    public boolean isLowerOrEqual(Version v) {
        return this.compareStatement(v, MAJORS_LESS, (a, b) -> a.floatValue() <= b.floatValue());
    }

    public boolean isEqual(Version v) {
        return this.compareStatement(v, MAJORS_EQUAL, (a, b) -> a.equals(b));
    }

    public String toString() {
        return this.major + "." + this.minor + "." + Version.patchToString(this.patch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && Float.compare(version.patch, this.patch) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, Float.valueOf(this.patch));
    }

    public static class MalformedVersionException
    extends RuntimeException {
        public MalformedVersionException(String s) {
            super(s);
        }
    }
}

