/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.util.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.orbyfied.j8.util.StringUtil;
import net.orbyfied.osf.util.Values;
import net.orbyfied.osf.util.logging.EventLevel;
import net.orbyfied.osf.util.logging.EventLog;

public class Event {
    protected final String id;
    protected Object message;
    protected EventLevel level = EventLevel.INFO;
    protected final List<Throwable> errors = new ArrayList<Throwable>();
    protected Values extra;
    protected EventLog log;

    public Event(String id) {
        this.id = id;
    }

    public Event forLog(EventLog log) {
        this.log = log;
        return this;
    }

    public Event push() {
        this.log.push(this);
        return this;
    }

    public String identifier() {
        return this.id;
    }

    public Values extra() {
        if (this.extra == null) {
            this.extra = new Values();
        }
        return this.extra;
    }

    public Event extra(Consumer<Values> consumer) {
        consumer.accept(this.extra());
        return this;
    }

    public Event withMessage(Object message) {
        this.message = message;
        return this;
    }

    public Event withMessage(String format, Object ... values) {
        this.message = StringUtil.format(format, values);
        return this;
    }

    public Event withError(Throwable t) {
        this.errors.add(t);
        return this;
    }

    public Event withLevel(EventLevel level) {
        this.level = level;
        return this;
    }

    public EventLevel getLevel() {
        return this.level;
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public Object getMessage() {
        return this.message;
    }
}

