/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.util.logging;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.orbyfied.j8.util.logging.LogHandler;
import net.orbyfied.j8.util.logging.LogText;
import net.orbyfied.j8.util.logging.Logger;
import net.orbyfied.j8.util.logging.LoggerGroup;
import net.orbyfied.j8.util.logging.io.LogOutput;
import net.orbyfied.osf.util.logging.EventLog;
import net.orbyfied.osf.util.logging.EventLogHandler;
import net.orbyfied.osf.util.logging.EventLogs;
import net.orbyfied.osf.util.worker.LoopWorker;
import net.orbyfied.osf.util.worker.SafeWorker;

public class Logging {
    private static final LoggerGroup GROUP = new LoggerGroup("OSF");
    public static final EventLogs EVENT_LOGS = new EventLogs().withInitializer(log -> {
        Logger logger = Logging.getLogger(log.getName());
        log.withHandler(new EventLogHandler("logger", event -> log.logString(event, logger)));
    });
    public static final PrintStream ERR;
    private static SafeWorker errWorker;
    public static final LogOutput FORMAT_CONTROLLED_STDOUT;
    private static boolean formatted;

    public static boolean isFormatted() {
        return formatted;
    }

    public static void setFormatted(boolean f) {
        formatted = f;
        if (FORMAT_CONTROLLED_STDOUT != null) {
            FORMAT_CONTROLLED_STDOUT.setFormatted(f);
        }
    }

    public static void setLogEvents(boolean b) {
        EVENT_LOGS.forAll(log -> {
            EventLogHandler handler = log.getHandler("logger");
            if (handler != null) {
                handler.setEnabled(b);
            }
        });
    }

    public static LoggerGroup getGroup() {
        return GROUP;
    }

    public static Logger getLogger(String name) {
        Logger logger = GROUP.getByName(name);
        if (logger != null) {
            return logger;
        }
        logger = GROUP.create(name);
        return logger;
    }

    public static EventLog getEventLog(String name) {
        return EVENT_LOGS.getOrCreate(name);
    }

    static {
        FORMAT_CONTROLLED_STDOUT = LogOutput.STDOUT;
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final BufferedOutputStream stream = new BufferedOutputStream(baos);
        ERR = new PrintStream(stream, false){

            @Override
            public synchronized void flush() {
                try {
                    stream.flush();
                    System.err.write(baos.toByteArray());
                    baos.reset();
                }
                catch (IOException e) {
                    e.printStackTrace(ERR);
                }
            }
        };
        errWorker = new LoopWorker("ErrorStreamWorker", dt -> ERR.flush()).setTargetUps(20.0f).commence();
        SimpleDateFormat format = new SimpleDateFormat("hh:mm:ss.SSSS");
        GROUP.addConfigure((group1, logger1) -> {
            logger1.prePipeline().addLast(LogHandler.of((pipeline, record) -> record.carry("time", new Date())).named("set-time"));
            logger1.pipeline().addLast(LogHandler.of((pipeline, record) -> {
                Date date = (Date)record.carried("time");
                LogText text = record.getText();
                LogText tTime = text.sub("time", 0);
                tTime.put("(");
                tTime.put("time-value", format.format(date));
                tTime.put(")");
            }).named("format-time"));
        });
    }
}

