/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.util.security;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import net.orbyfied.osf.util.security.EncryptionProfile;

public class AsymmetricEncryptionProfile
extends EncryptionProfile<AsymmetricEncryptionProfile> {
    public static final AsymmetricEncryptionProfile UTILITY_RSA_1024 = new AsymmetricEncryptionProfile("RSA", "ECB", "PKCS1Padding", "RSA", 1024);
    public static final int UNPADDED_BLOCK_SIZE = 117;
    public static final int PADDED_BLOCK_SIZE = 128;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private String keyAlgorithm;
    private KeyFactory keyFactory;
    private int keyLength;

    public static KeyFactory getKeyFactorySafe(String name) {
        try {
            return KeyFactory.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.err("Invalid key factory '" + name + "': No such algorithm", new Object[0]);
            return null;
        }
    }

    public static KeyPairGenerator getKeyPairGeneratorSafe(String name) {
        try {
            return KeyPairGenerator.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.err("Invalid key pair generator '" + name + "': No such algorithm", new Object[0]);
            return null;
        }
    }

    public AsymmetricEncryptionProfile() {
        super(EncryptionProfile.CipherType.SYMMETRIC, 117, 128);
    }

    public AsymmetricEncryptionProfile(String algorithm, String mode, String padding, String keyAlgorithm) {
        super(EncryptionProfile.CipherType.ASYMMETRIC, 117, 128, algorithm, mode, padding);
        this.withKeyAlgorithm(keyAlgorithm);
    }

    public AsymmetricEncryptionProfile(String algorithm, String mode, String padding, String keyAlgorithm, int keyLength) {
        this(algorithm, mode, padding, keyAlgorithm);
        this.keyLength = keyLength;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public KeyFactory getKeyFactory() {
        return this.keyFactory;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public AsymmetricEncryptionProfile withKeyAlgorithm(String algorithm) {
        Objects.requireNonNull(algorithm, "algorithm cannot be null");
        this.keyAlgorithm = algorithm;
        this.keyFactory = AsymmetricEncryptionProfile.getKeyFactorySafe(algorithm);
        if (this.keyFactory == null) {
            throw new IllegalArgumentException("key factory is null");
        }
        return this;
    }

    public synchronized AsymmetricEncryptionProfile withPublicKey(PublicKey key) {
        this.publicKey = key;
        return this;
    }

    public synchronized AsymmetricEncryptionProfile withPrivateKey(PrivateKey key) {
        this.privateKey = key;
        return this;
    }

    public AsymmetricEncryptionProfile withKeyLength(int len) {
        this.keyLength = len;
        return this;
    }

    @Override
    public AsymmetricEncryptionProfile generateKeys(int len) {
        if (this.keyAlgorithm == null) {
            throw new IllegalStateException();
        }
        try {
            KeyPairGenerator gen = AsymmetricEncryptionProfile.getKeyPairGeneratorSafe(this.keyAlgorithm);
            if (gen == null) {
                return this;
            }
            gen.initialize(len);
            KeyPair pair = gen.generateKeyPair();
            this.keyLength = len;
            this.privateKey = pair.getPrivate();
            this.publicKey = pair.getPublic();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public AsymmetricEncryptionProfile generateKeys() {
        return this.generateKeys(this.keyLength);
    }

    @Override
    public Key getEncryptionKey() {
        return this.publicKey;
    }

    @Override
    public Key getDecryptionKey() {
        return this.privateKey;
    }

    @Override
    public synchronized AsymmetricEncryptionProfile withKey(String name, Key key) {
        switch (name.toLowerCase()) {
            case "public": {
                this.publicKey = (PublicKey)key;
                break;
            }
            case "private": {
                this.privateKey = (PrivateKey)key;
                break;
            }
            default: {
                throw new IllegalArgumentException("no key named '" + name + "'");
            }
        }
        return this;
    }

    @Override
    public <K extends Key> K decodeKey(Class<K> kClass, byte[] bytes) {
        if (this.keyFactory == null) {
            throw new IllegalStateException();
        }
        try {
            if (PublicKey.class.isAssignableFrom(kClass)) {
                X509EncodedKeySpec publicSpec = new X509EncodedKeySpec(bytes);
                return (K)this.keyFactory.generatePublic(publicSpec);
            }
            if (PrivateKey.class.isAssignableFrom(kClass)) {
                PKCS8EncodedKeySpec privateSpec = new PKCS8EncodedKeySpec(bytes);
                return (K)this.keyFactory.generatePrivate(privateSpec);
            }
            throw new IllegalArgumentException("unknown key type to decode to: " + kClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

