/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.util.security;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import net.orbyfied.j8.util.logging.Logger;
import net.orbyfied.osf.util.logging.Logging;

public abstract class EncryptionProfile<S extends EncryptionProfile> {
    protected static final Logger LOGGER = Logging.getLogger("Encryption");
    private final S self = this;
    protected final int unpaddedBlockSize;
    protected final int paddedBlockSize;
    protected final CipherType cipherType;
    protected String algorithm;
    protected String mode;
    protected String padding;
    protected Cipher cipher;

    public static Cipher getCipherSafe(String name) {
        try {
            return Cipher.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.err("Invalid cipher '" + name + "': No such algorithm", new Object[0]);
        }
        catch (NoSuchPaddingException e) {
            LOGGER.err("Invalid cipher '" + name + "': No such padding", new Object[0]);
        }
        return null;
    }

    protected String toBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public byte[] fromBase64(String str) {
        return Base64.getDecoder().decode(str);
    }

    public EncryptionProfile(CipherType type, int unpaddedBlockSize, int paddedBlockSize) {
        this.cipherType = type;
        this.unpaddedBlockSize = unpaddedBlockSize;
        this.paddedBlockSize = paddedBlockSize;
    }

    public EncryptionProfile(CipherType type, int unpaddedBlockSize, int paddedBlockSize, String algorithm, String mode, String padding) {
        this(type, unpaddedBlockSize, paddedBlockSize);
        this.withCipher(algorithm, mode, padding);
    }

    public CipherType getCipherType() {
        return this.cipherType;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getMode() {
        return this.mode;
    }

    public String getPadding() {
        return this.padding;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public S withCipher(Cipher cipher) {
        this.algorithm = cipher.getAlgorithm();
        this.cipher = cipher;
        return this.self;
    }

    public S withCipher(String algorithm, String mode, String padding) {
        this.algorithm = algorithm;
        this.mode = mode;
        this.padding = padding;
        try {
            this.cipher = Cipher.getInstance(algorithm + "/" + mode + "/" + padding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.self;
    }

    public abstract S generateKeys(int var1);

    public abstract Key getEncryptionKey();

    public abstract Key getDecryptionKey();

    public abstract S withKey(String var1, Key var2);

    public abstract <K extends Key> K decodeKey(Class<K> var1, byte[] var2);

    public byte[] encodeKey(Key key) {
        return key != null ? key.getEncoded() : null;
    }

    public <K extends Key> K decodeKeyFromBase64(Class<K> kClass, String key) {
        return this.decodeKey(kClass, this.fromBase64(key));
    }

    public String encodeKeyToBase64(Key key) {
        return this.toBase64(this.encodeKey(key));
    }

    public byte[] encrypt(byte[] bytes) {
        if (this.cipher == null) {
            throw new IllegalStateException();
        }
        try {
            this.cipher.init(1, this.getEncryptionKey());
            return this.cipher.doFinal(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] decrypt(byte[] bytes) {
        if (this.cipher == null) {
            throw new IllegalStateException();
        }
        try {
            this.cipher.init(2, this.getDecryptionKey());
            return this.cipher.doFinal(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] encryptUTF(String str) {
        return this.encrypt(str.getBytes(StandardCharsets.UTF_8));
    }

    public String decryptUTF(byte[] bytes) {
        return new String(this.decrypt(bytes), StandardCharsets.UTF_8);
    }

    public String encryptToBase64(byte[] bytes) {
        return this.toBase64(this.encrypt(bytes));
    }

    public byte[] decryptFromBase64(String str) {
        return this.decrypt(this.fromBase64(str));
    }

    public EncryptingOutputStream encryptingOutputStream(OutputStream out) {
        return new EncryptingOutputStream(out);
    }

    public DecryptingInputStream decryptingInputStream(InputStream in) {
        return new DecryptingInputStream(in);
    }

    public static enum CipherType {
        SYMMETRIC,
        ASYMMETRIC;

    }

    public class EncryptingOutputStream
    extends OutputStream {
        final int blockSize;
        final OutputStream stream;
        byte[] buf;
        int bi;

        public EncryptingOutputStream(OutputStream stream) {
            this.blockSize = EncryptionProfile.this.unpaddedBlockSize;
            this.buf = new byte[this.blockSize];
            this.bi = 0;
            this.stream = stream;
        }

        @Override
        public void write(int b) throws IOException {
            byte by = (byte)b;
            this.buf[this.bi++] = by;
            if (this.bi >= this.buf.length) {
                this.flush();
                this.buf = new byte[this.blockSize];
                this.bi = 0;
            }
        }

        @Override
        public void flush() throws IOException {
            byte[] encrypted = EncryptionProfile.this.encrypt(this.buf);
            this.stream.write(encrypted);
        }

        public DataOutputStream toDataStream() {
            return new DataOutputStream(this);
        }
    }

    public class DecryptingInputStream
    extends InputStream {
        final int blockSize;
        InputStream stream;
        byte[] buf;
        int used;

        public DecryptingInputStream(InputStream stream) {
            this.blockSize = EncryptionProfile.this.paddedBlockSize;
            this.buf = new byte[this.blockSize];
            this.used = 0;
            this.stream = stream;
        }

        @Override
        public int read() throws IOException {
            if (this.used == 0 || this.used >= this.buf.length) {
                byte[] encrypted = this.stream.readNBytes(this.blockSize);
                this.buf = EncryptionProfile.this.decrypt(encrypted);
            }
            byte by = this.buf[this.used++];
            return by;
        }

        public DataInputStream toDataStream() {
            return new DataInputStream(this);
        }
    }
}

