/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.util.security;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.orbyfied.osf.util.security.EncryptionProfile;

public class SymmetricEncryptionProfile
extends EncryptionProfile<SymmetricEncryptionProfile> {
    public static final int UNPADDED_BLOCK_SIZE = 117;
    public static final int PADDED_BLOCK_SIZE = 128;
    private SecretKey secretKey;
    private String keyAlgorithm;
    private int keyLength;

    public static KeyGenerator getKeyGeneratorSafe(String name) {
        try {
            return KeyGenerator.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.err("Invalid key generator '" + name + "': No such algorithm", new Object[0]);
            return null;
        }
    }

    public SymmetricEncryptionProfile() {
        super(EncryptionProfile.CipherType.ASYMMETRIC, 117, 128);
    }

    public SymmetricEncryptionProfile(String algorithm, String mode, String padding, String keyAlgorithm) {
        super(EncryptionProfile.CipherType.SYMMETRIC, 117, 128, algorithm, mode, padding);
        this.withKeyAlgorithm(keyAlgorithm);
    }

    public SymmetricEncryptionProfile(String algorithm, String mode, String padding, String keyAlgorithm, int keyLength) {
        this(algorithm, mode, padding, keyAlgorithm);
        this.withKeyLength(keyLength);
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public SymmetricEncryptionProfile withKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        return this;
    }

    public SymmetricEncryptionProfile withKeyLength(int len) {
        this.keyLength = len;
        return this;
    }

    @Override
    public SymmetricEncryptionProfile generateKeys(int len) {
        if (this.keyAlgorithm == null) {
            throw new IllegalStateException();
        }
        try {
            KeyGenerator generator = SymmetricEncryptionProfile.getKeyGeneratorSafe(this.keyAlgorithm);
            if (generator == null) {
                return this;
            }
            generator.init(len);
            this.secretKey = generator.generateKey();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public SymmetricEncryptionProfile generateKeys() {
        return this.generateKeys(this.keyLength);
    }

    @Override
    public Key getEncryptionKey() {
        return this.secretKey;
    }

    @Override
    public Key getDecryptionKey() {
        return this.secretKey;
    }

    @Override
    public SymmetricEncryptionProfile withKey(String name, Key key) {
        this.secretKey = (SecretKey)key;
        return this;
    }

    @Override
    public <K extends Key> K decodeKey(Class<K> kClass, byte[] bytes) {
        if (this.keyAlgorithm == null) {
            throw new IllegalStateException();
        }
        try {
            if (SecretKey.class.isAssignableFrom(kClass)) {
                SecretKeySpec spec = new SecretKeySpec(bytes, this.keyAlgorithm);
                return (K)spec;
            }
            throw new IllegalArgumentException("unknown key type to decode to: " + kClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

