/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.util.worker;

import java.util.function.Consumer;
import net.orbyfied.osf.util.worker.SafeWorker;

public class LoopWorker
extends SafeWorker {
    Consumer<Float> tickTarget;
    public float targetUps;
    private float targetDt;
    public float dt;
    public float ups;

    public LoopWorker() {
    }

    public LoopWorker(Consumer<Float> tickTarget) {
        this();
        this.tickTarget = tickTarget;
    }

    public LoopWorker(String name) {
        super(name);
    }

    public LoopWorker(String name, Consumer<Float> tickTarget) {
        this(name);
        this.tickTarget = tickTarget;
    }

    public LoopWorker setTargetUps(float ups) {
        if (ups != -1.0f) {
            this.targetUps = ups;
            this.targetDt = 1.0f / ups;
        } else {
            this.targetUps = ups;
        }
        return this;
    }

    @Override
    public void run() {
        while (this.shouldRun()) {
            long t1 = System.currentTimeMillis();
            this.tick();
            long t2 = System.currentTimeMillis();
            long t = t2 - t1;
            this.dt = (float)t / 1000.0f;
            if (this.targetUps != -1.0f) {
                this.ups = Math.min(this.targetUps, 1.0f / this.dt);
                if (!(this.dt < this.targetDt)) continue;
                this.sleepSafe((int)((this.targetDt - this.dt) * 1000.0f));
                continue;
            }
            this.ups = 1.0f / this.dt;
        }
    }

    public void tick() {
        if (this.tickTarget != null) {
            this.tickTarget.accept(Float.valueOf(this.dt));
        }
    }

    private void sleepSafe(long ms) {
        try {
            LoopWorker.sleep(ms);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

