/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.osf.util.worker;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.orbyfied.j8.util.functional.ThrowableRunnable;

public class SafeWorker
extends Thread {
    final AtomicBoolean active = new AtomicBoolean(false);
    ThrowableRunnable target;
    Predicate<SafeWorker> activityPredicate;
    BiConsumer<SafeWorker, Throwable> errorHandler;

    public SafeWorker() {
        this.target = null;
    }

    public SafeWorker(ThrowableRunnable target) {
        this.target = target;
    }

    public SafeWorker(String name) {
        super(name);
        this.target = null;
    }

    public SafeWorker(String name, ThrowableRunnable target) {
        super(name);
        this.target = target;
    }

    public Predicate<SafeWorker> getActivityPredicate() {
        return this.activityPredicate;
    }

    public SafeWorker withActivityPredicate(Predicate<SafeWorker> predicate) {
        this.activityPredicate = predicate;
        return this;
    }

    public BiConsumer<SafeWorker, Throwable> getErrorHandler() {
        return this.errorHandler;
    }

    public SafeWorker withErrorHandler(BiConsumer<SafeWorker, Throwable> consumer) {
        this.errorHandler = consumer;
        return this;
    }

    public SafeWorker withTarget(ThrowableRunnable runnable) {
        this.target = runnable;
        return this;
    }

    public SafeWorker setActive(boolean b) {
        this.active.set(b);
        return this;
    }

    public boolean isSetActive() {
        return this.active.get();
    }

    public boolean shouldRun() {
        return this.active.get() && (this.activityPredicate == null || this.activityPredicate.test(this));
    }

    @Override
    public synchronized void start() {
        this.active.set(true);
        super.start();
    }

    public synchronized SafeWorker commence() {
        this.start();
        return this;
    }

    public void terminate() {
        this.active.set(false);
        try {
            super.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void await() {
        try {
            this.join();
        }
        catch (Exception e) {
            System.err.println("Failed to await worker " + this.getName());
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            this.runSafe();
        }
        catch (Throwable t) {
            if (this.errorHandler != null) {
                this.errorHandler.accept(this, t);
            }
            System.err.println("Error in worker thread " + this.getName());
            t.printStackTrace();
        }
        this.active.set(false);
    }

    public void runSafe() throws Throwable {
        if (this.target != null) {
            this.target.run();
        }
    }
}

