package cicada.authorization;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import cicada.authorization.config.GetUserIdRet;
import cicada.authorization.config.UserSessionService;
import cicada.core.BeanFactory;

public class UserAuthClient
{
	static final Logger log = LoggerFactory.getLogger(UserAuthClient.class);
	static final byte[] lock = new byte[1];
	
	public static GetUserIdRet getUserId(String sessionId)
	{
		UserSessionService.Iface iface = BeanFactory.getBeanByType(UserSessionService.Iface.class);
		try
		{
			if (iface != null)
			{
				synchronized (lock)
				{
					GetUserIdRet result = iface.GetUserId(sessionId);
					return result;
				}
			}
		}
		catch (Exception e)
		{
			log.error("cicada.authorization 版块获取thrift 服务错误:{},详细信息:{}", e.getMessage(), e.getStackTrace());
		}
		log.error("cicada.authorization 版块获取thrift 服务错误,返回空值");
		return null;
	}
}
