package cicada.authorization;

import javax.servlet.http.HttpServletRequest;

class UserContext
{
	private final String UserIdKey = "LY_UserSession_UserId";

	private final String UserTypeKey = "LY_UserType";

	private String userId;

	public String getUserId(HttpServletRequest request) throws Exception
	{
		if (request.getAttribute(UserIdKey) != null)
		{
			return request.getAttribute(UserIdKey).toString();
		}
		throw new Exception("请为方法添加UserAuthorizationAttribute标签");
	}

	public void setUserId(String userId, HttpServletRequest request)
	{
		request.setAttribute(UserIdKey, userId);
	}

	private UserTypeEnum userType;

	public UserTypeEnum getUserType(HttpServletRequest request) throws Exception
	{
		if (request.getAttribute(UserTypeKey) != null)
		{
			return (UserTypeEnum) request.getAttribute(UserTypeKey);
		}
		throw new Exception("请为方法添加UserAuthorizationAttribute标签");
	}

	public void setUserType(UserTypeEnum userType, HttpServletRequest request)
	{
		request.setAttribute(UserTypeKey, userType);
	}
}

