/*
 * Decompiled with CFR 0.152.
 */
package net.osomahe.esk;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import net.osomahe.esk.eventstore.entity.EventStoreEvent;
import net.osomahe.esk.eventstore.entity.EventSubscription;

public class EventStoreExtension
implements Extension {
    private static final Logger logger = Logger.getLogger(EventStoreExtension.class.getName());
    private final List<Class<? extends EventStoreEvent>> events = new ArrayList<Class<? extends EventStoreEvent>>();

    public void processObserverMethod(@Observes ProcessObserverMethod<? extends EventStoreEvent, ?> processObserverMethod) {
        Method method = processObserverMethod.getAnnotatedMethod().getJavaMember();
        Class<?> eventClass = method.getParameterTypes()[0];
        this.events.add(eventClass);
        logger.info("Found event: " + eventClass);
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager beanManager) {
        this.events.forEach(eventClass -> beanManager.fireEvent((Object)new EventSubscription((Class<? extends EventStoreEvent>)eventClass), new Annotation[0]));
    }
}

