/*
 * Decompiled with CFR 0.152.
 */
package net.osomahe.esk.config.boundary;

import java.util.Map;
import java.util.Properties;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import net.osomahe.esk.config.boundary.EventStorePublisherConfig;
import net.osomahe.esk.config.boundary.EventStoreSubscriberConfig;
import net.osomahe.esk.config.entity.KafkaConsumerConfig;
import net.osomahe.esk.config.entity.KafkaProducerConfig;

@Stateless
public class ConfigurationBoundary {
    private static final String DEFAULT_KAFKA_URL = "localhost:9092";
    private static final String DEFAULT_APPLICATION_ID = "client-application";
    @Inject
    @KafkaProducerConfig
    private Instance<Properties> instanceProducer;
    @Inject
    @KafkaConsumerConfig
    private Instance<Properties> instanceConsumer;
    @Inject
    private Instance<EventStorePublisherConfig> instancePublisher;
    @Inject
    private Instance<EventStoreSubscriberConfig> instanceSubscriber;

    public Properties getKafkaProducerConfig() {
        if (this.instancePublisher.isResolvable()) {
            return ((EventStorePublisherConfig)this.instancePublisher.get()).getKafkaProducerConfig();
        }
        Properties producerConfig = this.getDefaultProducerConfig();
        if (this.instanceProducer.isResolvable()) {
            producerConfig.putAll((Map<?, ?>)((Map)this.instanceProducer.get()));
        }
        return producerConfig;
    }

    private Properties getDefaultProducerConfig() {
        Properties props = new Properties();
        props.put("bootstrap.servers", DEFAULT_KAFKA_URL);
        props.put("acks", "all");
        return props;
    }

    public Properties getKafkaConsumerConfig() {
        if (this.instanceSubscriber.isResolvable()) {
            return ((EventStoreSubscriberConfig)this.instanceSubscriber.get()).getKafkaConsumerConfig();
        }
        Properties consumerConfig = this.getDefaultConsumerConfig();
        if (this.instanceConsumer.isResolvable()) {
            consumerConfig.putAll((Map<?, ?>)((Map)this.instanceConsumer.get()));
        }
        return consumerConfig;
    }

    private Properties getDefaultConsumerConfig() {
        Properties props = new Properties();
        props.put("bootstrap.servers", DEFAULT_KAFKA_URL);
        props.put("group.id", DEFAULT_APPLICATION_ID);
        props.put("auto.offset.reset", "earliest");
        return props;
    }
}

