/*
 * Decompiled with CFR 0.152.
 */
package net.osomahe.esk.eventstore.control;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class EventDeserializer
implements Deserializer<JsonObject> {
    private static final Logger logger = Logger.getLogger(EventDeserializer.class.getName());

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject deserialize(String topic, byte[] data) {
        try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
            JsonObject jsonObject = Json.createReader((InputStream)input).readObject();
            return jsonObject;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not deserialize event: " + e.getMessage());
            throw new SerializationException("Could not deserialize event", (Throwable)e);
        }
    }

    public void close() {
    }
}

