/*
 * Decompiled with CFR 0.152.
 */
package net.osomahe.esk.eventstore.control;

import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import net.osomahe.esk.eventstore.entity.EventName;
import net.osomahe.esk.eventstore.entity.EventStoreEvent;
import org.apache.kafka.common.serialization.Serializer;

public class EventSerializer
implements Serializer<EventStoreEvent> {
    private final Jsonb jsonb = JsonbBuilder.create();

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public void close() {
    }

    public byte[] serialize(String topic, EventStoreEvent event) {
        if (event == null) {
            return null;
        }
        String data = this.jsonb.toJson((Object)event);
        JsonObject jo = Json.createObjectBuilder().add("name", this.getEventName(event.getClass())).add("dateTime", ZonedDateTime.now().toEpochSecond()).add("data", (JsonValue)this.jsonb.fromJson(data, JsonObject.class)).build();
        return this.jsonb.toJson((Object)jo).getBytes(StandardCharsets.UTF_8);
    }

    private String getEventName(Class<? extends EventStoreEvent> eventClass) {
        EventName eventName = eventClass.getAnnotation(EventName.class);
        if (eventName != null) {
            return eventName.value();
        }
        return eventClass.getSimpleName();
    }
}

