/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import java.util.regex.Pattern;
import net.ossindex.version.IVersion;
import net.ossindex.version.InvalidRangeException;

public class NamedVersion
implements IVersion {
    private static final Pattern SEMANTIC_RANGE_SPECIAL_CHARS = Pattern.compile("[><=|&]");
    private static final Pattern SET_RANGE_SPECIAL_CHARS = Pattern.compile("^[\\(\\[]");
    private static final Pattern INVALID_VERSION_CHARS = Pattern.compile("[ \t\n\r]");
    private String name;

    public NamedVersion(String name) throws InvalidRangeException {
        if (!this.isValidNamedVersion(name)) {
            throw new InvalidRangeException("Could not parse: " + name);
        }
        this.name = name;
    }

    @Override
    public int compareTo(IVersion o) {
        return this.name.compareTo(o.toString());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof NamedVersion) {
            return this.name.equals(((NamedVersion)o).name);
        }
        return false;
    }

    @Override
    public int getMajor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMinor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPatch() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBuild() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStable() {
        return false;
    }

    public String toString() {
        return this.name;
    }

    private boolean isValidNamedVersion(String s) {
        return !SEMANTIC_RANGE_SPECIAL_CHARS.matcher(s).find() && !SET_RANGE_SPECIAL_CHARS.matcher(s).find() && !INVALID_VERSION_CHARS.matcher(s).find();
    }
}

