/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import net.ossindex.version.IVersion;
import net.ossindex.version.impl.NamedVersion;

public class VersionImpl
implements IVersion {
    private int major;
    private int minor;
    private int patch;
    private int build;
    private String suffix;

    public VersionImpl(int major) {
        this.major = major;
    }

    public VersionImpl(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public VersionImpl(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public VersionImpl(int major, int minor, int patch, int build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public VersionImpl(int major, int minor, int patch, String suffix) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = this.build;
        this.suffix = suffix;
    }

    public VersionImpl(int major, int minor, int patch, int build, String suffix) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.suffix = suffix;
    }

    @Override
    public int getBuild() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(IVersion v) {
        if (v instanceof NamedVersion) {
            throw new IllegalArgumentException("Cannot compare named version with unnamed version");
        }
        if (v.getMajor() > this.major) {
            return -1;
        }
        if (this.major > v.getMajor()) {
            return 1;
        }
        if (v.getMinor() > this.minor) {
            return -1;
        }
        if (this.minor > v.getMinor()) {
            return 1;
        }
        if (v.getPatch() > this.patch) {
            return -1;
        }
        if (this.patch > v.getPatch()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getPatch() {
        return this.patch;
    }

    @Override
    public boolean isStable() {
        return this.suffix == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append(".");
        sb.append(this.minor);
        sb.append(".");
        sb.append(this.patch);
        if (this.build > 0) {
            sb.append(".");
            sb.append(this.build);
        }
        if (this.suffix != null) {
            sb.append("-");
            sb.append(this.suffix);
        }
        return sb.toString();
    }
}

