/*
 * Decompiled with CFR 0.152.
 */
package net.pearx.kasechange.splitter;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.pearx.kasechange.splitter.WordSplitter;
import net.pearx.kasechange.splitter.WordSplitterConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0014\u0010\r\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u0007*\u00060\u000fj\u0002`\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/pearx/kasechange/splitter/WordSplitterConfigurable;", "Lnet/pearx/kasechange/splitter/WordSplitter;", "config", "Lnet/pearx/kasechange/splitter/WordSplitterConfig;", "(Lnet/pearx/kasechange/splitter/WordSplitterConfig;)V", "splitToWords", "", "", "string", "isDigitOrLowerCase", "", "", "treatDigitsAsUppercase", "isDigitOrUpperCase", "toStringAndClear", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "kasechange"})
@SourceDebugExtension(value={"SMAP\nWordSplitterConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WordSplitterConfigurable.kt\nnet/pearx/kasechange/splitter/WordSplitterConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class WordSplitterConfigurable
implements WordSplitter {
    @NotNull
    private final WordSplitterConfig config;

    public WordSplitterConfigurable(@NotNull WordSplitterConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @Override
    @NotNull
    public List<String> splitToWords(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        List list = new ArrayList();
        StringBuilder word = new StringBuilder();
        int n = string.length();
        for (int index = 0; index < n; ++index) {
            char c = string.charAt(index);
            if (this.config.getBoundaries().contains(Character.valueOf(c))) {
                list.add(this.toStringAndClear(word));
                continue;
            }
            if (this.config.getHandleCase() && this.isDigitOrUpperCase(c, this.config.getTreatDigitsAsUppercase())) {
                boolean nextLowerCase;
                boolean hasPrev = index > 0;
                boolean hasNext = index < string.length() - 1;
                boolean prevLowerCase = hasPrev && this.isDigitOrLowerCase(string.charAt(index - 1), this.config.getTreatDigitsAsUppercase());
                boolean prevDigitUpperCase = hasPrev && this.isDigitOrUpperCase(string.charAt(index - 1), this.config.getTreatDigitsAsUppercase());
                boolean bl = nextLowerCase = hasNext && this.isDigitOrLowerCase(string.charAt(index + 1), this.config.getTreatDigitsAsUppercase());
                if (prevLowerCase || prevDigitUpperCase && nextLowerCase) {
                    list.add(this.toStringAndClear(word));
                }
            }
            word.append(c);
        }
        list.add(this.toStringAndClear(word));
        return list;
    }

    private final String toStringAndClear(StringBuilder $this$toStringAndClear) {
        String string;
        String it = string = $this$toStringAndClear.toString();
        boolean bl = false;
        StringsKt.clear((StringBuilder)$this$toStringAndClear);
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString().also { clear() }");
        return string2;
    }

    private final boolean isDigitOrUpperCase(char $this$isDigitOrUpperCase, boolean treatDigitsAsUppercase) {
        return treatDigitsAsUppercase && Character.isDigit($this$isDigitOrUpperCase) || Character.isUpperCase($this$isDigitOrUpperCase);
    }

    private final boolean isDigitOrLowerCase(char $this$isDigitOrLowerCase, boolean treatDigitsAsUppercase) {
        return !treatDigitsAsUppercase && Character.isDigit($this$isDigitOrLowerCase) || Character.isLowerCase($this$isDigitOrLowerCase);
    }
}

