/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.Function;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

final class CommandOperationHelper {
    private static final List<Integer> RETRYABLE_ERROR_CODES = Arrays.asList(6, 7, 89, 91, 189, 262, 9001, 13436, 13435, 11602, 11600, 10107);
    static final String RETRYABLE_WRITE_ERROR_LABEL = "RetryableWriteError";

    static CommandWriteTransformer<BsonDocument, Void> writeConcernErrorTransformer() {
        return (result, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return null;
        };
    }

    static CommandWriteTransformerAsync<BsonDocument, Void> writeConcernErrorWriteTransformer() {
        return (result, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return null;
        };
    }

    static CommandWriteTransformerAsync<BsonDocument, Void> writeConcernErrorTransformerAsync() {
        return (result, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return null;
        };
    }

    static Function<BsonDocument, BsonDocument> noOpRetryCommandModifier() {
        return command -> command;
    }

    static BsonDocument executeCommand(ReadBinding binding, String database, CommandCreator commandCreator, boolean retryReads) {
        return CommandOperationHelper.executeCommand(binding, database, commandCreator, new BsonDocumentCodec(), retryReads);
    }

    static <T> T executeCommand(ReadBinding binding, String database, CommandCreator commandCreator, CommandReadTransformer<BsonDocument, T> transformer, boolean retryReads) {
        return CommandOperationHelper.executeCommand(binding, database, commandCreator, new BsonDocumentCodec(), transformer, retryReads);
    }

    static <T> T executeCommand(ReadBinding binding, String database, CommandCreator commandCreator, Decoder<T> decoder, boolean retryReads) {
        return CommandOperationHelper.executeCommand(binding, database, commandCreator, decoder, new IdentityReadTransformer(), retryReads);
    }

    static <D, T> T executeCommand(ReadBinding binding, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, boolean retryReads) {
        return (T)OperationHelper.withReadConnectionSource(binding, source -> CommandOperationHelper.executeCommandWithConnection(binding, source, database, commandCreator, decoder, transformer, retryReads, source.getConnection()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static <D, T> T executeCommandWithConnection(ReadBinding binding, ConnectionSource source, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, boolean retryReads, Connection connection) {
        MongoException exception;
        BsonDocument command = commandCreator.create(source.getServerDescription(), connection.getDescription());
        T t = CommandOperationHelper.executeCommand(database, command, decoder, source, connection, binding.getReadPreference(), transformer, binding.getSessionContext(), binding.getServerApi());
        connection.release();
        return t;
        {
            catch (MongoException e) {
                try {
                    exception = e;
                    if (!CommandOperationHelper.shouldAttemptToRetryRead(retryReads, e)) {
                        if (retryReads) {
                            CommandOperationHelper.logUnableToRetry(command.getFirstKey(), e);
                        }
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    connection.release();
                }
            }
        }
        return CommandOperationHelper.retryCommand(binding, database, commandCreator, decoder, transformer, exception);
    }

    private static <D, T> T retryCommand(ReadBinding binding, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, MongoException originalException) {
        return (T)OperationHelper.withReleasableConnection(binding, originalException, (source, connection) -> {
            try {
                if (!OperationHelper.canRetryRead(source.getServerDescription(), connection.getDescription(), binding.getSessionContext())) {
                    throw originalException;
                }
                BsonDocument retryCommand = commandCreator.create(source.getServerDescription(), connection.getDescription());
                CommandOperationHelper.logRetryExecute(retryCommand.getFirstKey(), originalException);
                Object t = CommandOperationHelper.executeCommand(database, retryCommand, decoder, source, connection, binding.getReadPreference(), transformer, binding.getSessionContext(), source.getServerApi());
                return t;
            }
            finally {
                connection.release();
            }
        });
    }

    static BsonDocument executeCommand(WriteBinding binding, String database, BsonDocument command) {
        return (BsonDocument)CommandOperationHelper.executeCommand(binding, database, command, new IdentityWriteTransformer());
    }

    static <T> T executeCommand(WriteBinding binding, String database, BsonDocument command, Decoder<T> decoder) {
        return CommandOperationHelper.executeCommand(binding, database, command, decoder, new IdentityWriteTransformer());
    }

    static <T> T executeCommand(WriteBinding binding, String database, BsonDocument command, CommandWriteTransformer<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeCommand(binding, database, command, new BsonDocumentCodec(), transformer);
    }

    static <D, T> T executeCommand(WriteBinding binding, String database, BsonDocument command, Decoder<D> decoder, CommandWriteTransformer<D, T> transformer) {
        return CommandOperationHelper.executeCommand(binding, database, command, new NoOpFieldNameValidator(), decoder, transformer);
    }

    static <T> T executeCommand(WriteBinding binding, String database, BsonDocument command, Connection connection, CommandWriteTransformer<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeCommand(binding, database, command, new BsonDocumentCodec(), connection, transformer);
    }

    static <T> T executeCommand(WriteBinding binding, String database, BsonDocument command, Decoder<BsonDocument> decoder, Connection connection, CommandWriteTransformer<BsonDocument, T> transformer) {
        Assertions.notNull("binding", binding);
        return CommandOperationHelper.executeWriteCommand(database, command, decoder, connection, ReadPreference.primary(), transformer, binding.getSessionContext(), binding.getServerApi());
    }

    static <T> T executeCommand(WriteBinding binding, String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<BsonDocument> decoder, Connection connection, CommandWriteTransformer<BsonDocument, T> transformer) {
        Assertions.notNull("binding", binding);
        return CommandOperationHelper.executeWriteCommand(database, command, fieldNameValidator, decoder, connection, ReadPreference.primary(), transformer, binding.getSessionContext(), binding.getServerApi());
    }

    static <D, T> T executeCommand(WriteBinding binding, String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, CommandWriteTransformer<D, T> transformer) {
        return (T)OperationHelper.withReleasableConnection(binding, (source, connection) -> {
            try {
                Object r = transformer.apply(CommandOperationHelper.executeCommand(database, command, fieldNameValidator, decoder, source, connection, ReadPreference.primary()), connection);
                return r;
            }
            finally {
                connection.release();
            }
        });
    }

    static BsonDocument executeCommand(WriteBinding binding, String database, BsonDocument command, Connection connection) {
        Assertions.notNull("binding", binding);
        return CommandOperationHelper.executeWriteCommand(database, command, new BsonDocumentCodec(), connection, ReadPreference.primary(), binding.getSessionContext(), binding.getServerApi());
    }

    private static <T> T executeCommand(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<T> decoder, ConnectionSource source, Connection connection, ReadPreference readPreference) {
        return CommandOperationHelper.executeCommand(database, command, fieldNameValidator, decoder, source, connection, readPreference, new IdentityReadTransformer(), source.getSessionContext(), source.getServerApi());
    }

    private static <D, T> T executeCommand(String database, BsonDocument command, Decoder<D> decoder, ConnectionSource source, Connection connection, ReadPreference readPreference, CommandReadTransformer<D, T> transformer, SessionContext sessionContext, ServerApi serverApi) {
        return CommandOperationHelper.executeCommand(database, command, new NoOpFieldNameValidator(), decoder, source, connection, readPreference, transformer, sessionContext, serverApi);
    }

    private static <D, T> T executeCommand(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, ConnectionSource source, Connection connection, ReadPreference readPreference, CommandReadTransformer<D, T> transformer, SessionContext sessionContext, ServerApi serverApi) {
        return transformer.apply(connection.command(database, command, fieldNameValidator, readPreference, decoder, sessionContext, serverApi), source, connection);
    }

    private static <T> T executeWriteCommand(String database, BsonDocument command, Decoder<T> decoder, Connection connection, ReadPreference readPreference, SessionContext sessionContext, ServerApi serverApi) {
        return CommandOperationHelper.executeWriteCommand(database, command, new NoOpFieldNameValidator(), decoder, connection, readPreference, new IdentityWriteTransformer(), sessionContext, serverApi);
    }

    private static <D, T> T executeWriteCommand(String database, BsonDocument command, Decoder<D> decoder, Connection connection, ReadPreference readPreference, CommandWriteTransformer<D, T> transformer, SessionContext sessionContext, ServerApi serverApi) {
        return CommandOperationHelper.executeWriteCommand(database, command, new NoOpFieldNameValidator(), decoder, connection, readPreference, transformer, sessionContext, serverApi);
    }

    private static <D, T> T executeWriteCommand(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, Connection connection, ReadPreference readPreference, CommandWriteTransformer<D, T> transformer, SessionContext sessionContext, ServerApi serverApi) {
        return transformer.apply(connection.command(database, command, fieldNameValidator, readPreference, decoder, sessionContext, serverApi), connection);
    }

    static void executeCommandAsync(AsyncReadBinding binding, String database, CommandCreator commandCreator, boolean retryReads, SingleResultCallback<BsonDocument> callback) {
        CommandOperationHelper.executeCommandAsync(binding, database, commandCreator, new BsonDocumentCodec(), retryReads, callback);
    }

    static <T> void executeCommandAsync(AsyncReadBinding binding, String database, CommandCreator commandCreator, Decoder<T> decoder, boolean retryReads, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeCommandAsync(binding, database, commandCreator, decoder, new IdentityTransformerAsync(), retryReads, callback);
    }

    static <T> void executeCommandAsync(AsyncReadBinding binding, String database, CommandCreator commandCreator, CommandReadTransformerAsync<BsonDocument, T> transformer, boolean retryReads, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeCommandAsync(binding, database, commandCreator, new BsonDocumentCodec(), transformer, retryReads, callback);
    }

    static <D, T> void executeCommandAsync(AsyncReadBinding binding, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> transformer, boolean retryReads, SingleResultCallback<T> originalCallback) {
        SingleResultCallback errorHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(originalCallback, OperationHelper.LOGGER);
        OperationHelper.withAsyncReadConnection(binding, (source, connection, t) -> {
            if (t != null) {
                OperationHelper.releasingCallback(errorHandlingCallback, source, connection).onResult(null, t);
            } else {
                CommandOperationHelper.executeCommandAsyncWithConnection(binding, source, database, commandCreator, decoder, transformer, retryReads, connection, errorHandlingCallback);
            }
        });
    }

    static <D, T> void executeCommandAsync(AsyncReadBinding binding, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> transformer, boolean retryReads, AsyncConnection connection, SingleResultCallback<T> originalCallback) {
        SingleResultCallback errorHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(originalCallback, OperationHelper.LOGGER);
        binding.getReadConnectionSource((source, t) -> CommandOperationHelper.executeCommandAsyncWithConnection(binding, source, database, commandCreator, decoder, transformer, retryReads, connection, errorHandlingCallback));
    }

    static <D, T> void executeCommandAsyncWithConnection(AsyncReadBinding binding, AsyncConnectionSource source, String database, CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> transformer, boolean retryReads, AsyncConnection connection, SingleResultCallback<T> callback) {
        try {
            BsonDocument command = commandCreator.create(source.getServerDescription(), connection.getDescription());
            connection.commandAsync(database, command, new NoOpFieldNameValidator(), binding.getReadPreference(), decoder, binding.getSessionContext(), binding.getServerApi(), CommandOperationHelper.createCommandCallback(binding, source, connection, database, binding.getReadPreference(), command, commandCreator, new NoOpFieldNameValidator(), decoder, transformer, retryReads, callback));
        }
        catch (IllegalArgumentException e) {
            connection.release();
            callback.onResult(null, e);
        }
    }

    private static <T, R> SingleResultCallback<T> createCommandCallback(final AsyncReadBinding binding, final AsyncConnectionSource oldSource, final AsyncConnection oldConnection, final String database, final ReadPreference readPreference, final BsonDocument originalCommand, final CommandCreator commandCreator, final FieldNameValidator fieldNameValidator, final Decoder<T> commandResultDecoder, final CommandReadTransformerAsync<T, R> transformer, final boolean retryReads, final SingleResultCallback<R> callback) {
        return new SingleResultCallback<T>(){

            @Override
            public void onResult(T result, Throwable originalError) {
                SingleResultCallback releasingCallback = OperationHelper.releasingCallback(callback, oldSource, oldConnection);
                if (originalError != null) {
                    this.checkRetryableException(originalError, releasingCallback);
                } else {
                    try {
                        releasingCallback.onResult(transformer.apply(result, oldSource, oldConnection), null);
                    }
                    catch (Throwable transformError) {
                        this.checkRetryableException(transformError, releasingCallback);
                    }
                }
            }

            private void checkRetryableException(Throwable originalError, SingleResultCallback<R> callback2) {
                if (!CommandOperationHelper.shouldAttemptToRetryRead(retryReads, originalError)) {
                    if (retryReads) {
                        CommandOperationHelper.logUnableToRetry(originalCommand.getFirstKey(), originalError);
                    }
                    callback2.onResult(null, originalError);
                } else {
                    oldSource.release();
                    oldConnection.release();
                    this.retryableCommand(originalError);
                }
            }

            private void retryableCommand(Throwable originalError) {
                OperationHelper.withAsyncReadConnection(binding, (source, connection, t) -> {
                    if (t != null) {
                        callback.onResult(null, originalError);
                    } else if (!OperationHelper.canRetryRead(source.getServerDescription(), connection.getDescription(), binding.getSessionContext())) {
                        OperationHelper.releasingCallback(callback, source, connection).onResult(null, originalError);
                    } else {
                        BsonDocument retryCommand = commandCreator.create(source.getServerDescription(), connection.getDescription());
                        CommandOperationHelper.logRetryExecute(retryCommand.getFirstKey(), originalError);
                        connection.commandAsync(database, retryCommand, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext(), binding.getServerApi(), new TransformingReadResultCallback(transformer, source, connection, OperationHelper.releasingCallback(callback, source, connection)));
                    }
                });
            }
        };
    }

    static void executeCommandAsync(AsyncWriteBinding binding, String database, BsonDocument command, AsyncConnection connection, SingleResultCallback<BsonDocument> callback) {
        CommandOperationHelper.executeCommandAsync(binding, database, command, connection, new IdentityWriteTransformerAsync(), callback);
    }

    static <T> void executeCommandAsync(AsyncWriteBinding binding, String database, BsonDocument command, AsyncConnection connection, CommandWriteTransformerAsync<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        Assertions.notNull("binding", binding);
        CommandOperationHelper.executeCommandAsync(database, command, new BsonDocumentCodec(), connection, ReadPreference.primary(), transformer, binding.getSessionContext(), binding.getServerApi(), callback);
    }

    private static <D, T> void executeCommandAsync(String database, BsonDocument command, Decoder<D> decoder, AsyncConnection connection, ReadPreference readPreference, CommandWriteTransformerAsync<D, T> transformer, SessionContext sessionContext, ServerApi serverApi, SingleResultCallback<T> callback) {
        connection.commandAsync(database, command, new NoOpFieldNameValidator(), readPreference, decoder, sessionContext, serverApi, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                try {
                    Object transformedResult = transformer.apply(result, connection);
                    callback.onResult(transformedResult, null);
                }
                catch (Exception e) {
                    callback.onResult(null, e);
                }
            }
        });
    }

    static <T, R> R executeRetryableCommand(WriteBinding binding, String database, ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, CommandCreator commandCreator, CommandWriteTransformer<T, R> transformer) {
        return CommandOperationHelper.executeRetryableCommand(binding, database, readPreference, fieldNameValidator, commandResultDecoder, commandCreator, transformer, CommandOperationHelper.noOpRetryCommandModifier());
    }

    static <T, R> R executeRetryableCommand(WriteBinding binding, String database, ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, CommandCreator commandCreator, CommandWriteTransformer<T, R> transformer, Function<BsonDocument, BsonDocument> retryCommandModifier) {
        return (R)OperationHelper.withReleasableConnection(binding, (source, connection) -> {
            MongoException exception;
            BsonDocument command = null;
            try {
                command = commandCreator.create(source.getServerDescription(), connection.getDescription());
                Object r = transformer.apply(connection.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext(), binding.getServerApi()), connection);
                return r;
            }
            catch (MongoException e) {
                exception = e;
                if (!CommandOperationHelper.shouldAttemptToRetryWrite(command, (Throwable)e, connection.getDescription().getMaxWireVersion())) {
                    if (CommandOperationHelper.isRetryWritesEnabled(command)) {
                        CommandOperationHelper.logUnableToRetry(command.getFirstKey(), e);
                    }
                    throw CommandOperationHelper.transformWriteException(exception);
                }
            }
            finally {
                connection.release();
            }
            if (binding.getSessionContext().hasActiveTransaction()) {
                binding.getSessionContext().clearTransactionContext();
            }
            BsonDocument originalCommand = command;
            MongoException originalException = exception;
            return OperationHelper.withReleasableConnection(binding, originalException, (source1, connection1) -> {
                try {
                    if (!OperationHelper.canRetryWrite(source1.getServerDescription(), connection1.getDescription(), binding.getSessionContext())) {
                        throw originalException;
                    }
                    BsonDocument retryCommand = (BsonDocument)retryCommandModifier.apply(originalCommand);
                    CommandOperationHelper.logRetryExecute(retryCommand.getFirstKey(), originalException);
                    try {
                        Object r = transformer.apply(connection1.command(database, retryCommand, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext(), binding.getServerApi()), connection1);
                        return r;
                    }
                    catch (MongoException e) {
                        CommandOperationHelper.addRetryableWriteErrorLabel(e, connection1.getDescription().getMaxWireVersion());
                        throw e;
                    }
                }
                finally {
                    connection1.release();
                }
            });
        });
    }

    static <T, R> void executeRetryableCommand(AsyncWriteBinding binding, String database, ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, CommandCreator commandCreator, CommandWriteTransformerAsync<T, R> transformer, SingleResultCallback<R> originalCallback) {
        CommandOperationHelper.executeRetryableCommand(binding, database, readPreference, fieldNameValidator, commandResultDecoder, commandCreator, transformer, CommandOperationHelper.noOpRetryCommandModifier(), originalCallback);
    }

    static <T, R> void executeRetryableCommand(AsyncWriteBinding binding, String database, ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, CommandCreator commandCreator, CommandWriteTransformerAsync<T, R> transformer, Function<BsonDocument, BsonDocument> retryCommandModifier, SingleResultCallback<R> originalCallback) {
        SingleResultCallback errorHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(originalCallback, OperationHelper.LOGGER);
        binding.getWriteConnectionSource((source, t) -> {
            if (t != null) {
                errorHandlingCallback.onResult(null, t);
            } else {
                source.getConnection((connection, t12) -> {
                    if (t12 != null) {
                        OperationHelper.releasingCallback(errorHandlingCallback, source).onResult(null, t12);
                    } else {
                        try {
                            BsonDocument command = commandCreator.create(source.getServerDescription(), connection.getDescription());
                            connection.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext(), binding.getServerApi(), CommandOperationHelper.createCommandCallback(binding, source, connection, database, readPreference, command, fieldNameValidator, commandResultDecoder, transformer, retryCommandModifier, errorHandlingCallback));
                        }
                        catch (Throwable t1) {
                            OperationHelper.releasingCallback(errorHandlingCallback, source, connection).onResult(null, t1);
                        }
                    }
                });
            }
        });
    }

    private static <T, R> SingleResultCallback<T> createCommandCallback(final AsyncWriteBinding binding, final AsyncConnectionSource oldSource, final AsyncConnection oldConnection, final String database, final ReadPreference readPreference, final BsonDocument command, final FieldNameValidator fieldNameValidator, final Decoder<T> commandResultDecoder, final CommandWriteTransformerAsync<T, R> transformer, final Function<BsonDocument, BsonDocument> retryCommandModifier, final SingleResultCallback<R> callback) {
        return new SingleResultCallback<T>(){

            @Override
            public void onResult(T result, Throwable originalError) {
                SingleResultCallback releasingCallback = OperationHelper.releasingCallback(callback, oldSource, oldConnection);
                if (originalError != null) {
                    this.checkRetryableException(originalError, releasingCallback);
                } else {
                    try {
                        releasingCallback.onResult(transformer.apply(result, oldConnection), null);
                    }
                    catch (Throwable transformError) {
                        this.checkRetryableException(transformError, releasingCallback);
                    }
                }
            }

            private void checkRetryableException(Throwable originalError, SingleResultCallback<R> releasingCallback) {
                if (!CommandOperationHelper.shouldAttemptToRetryWrite(command, originalError, oldConnection.getDescription().getMaxWireVersion())) {
                    if (CommandOperationHelper.isRetryWritesEnabled(command)) {
                        CommandOperationHelper.logUnableToRetry(command.getFirstKey(), originalError);
                    }
                    releasingCallback.onResult(null, originalError instanceof MongoException ? CommandOperationHelper.transformWriteException((MongoException)originalError) : originalError);
                } else {
                    oldConnection.release();
                    oldSource.release();
                    if (binding.getSessionContext().hasActiveTransaction()) {
                        binding.getSessionContext().clearTransactionContext();
                    }
                    this.retryableCommand(originalError);
                }
            }

            private void retryableCommand(Throwable originalError) {
                BsonDocument retryCommand = (BsonDocument)retryCommandModifier.apply(command);
                CommandOperationHelper.logRetryExecute(retryCommand.getFirstKey(), originalError);
                OperationHelper.withAsyncConnection(binding, (source, connection, t) -> {
                    if (t != null) {
                        callback.onResult(null, originalError);
                    } else if (!OperationHelper.canRetryWrite(source.getServerDescription(), connection.getDescription(), binding.getSessionContext())) {
                        OperationHelper.releasingCallback(callback, source, connection).onResult(null, originalError);
                    } else {
                        connection.commandAsync(database, retryCommand, fieldNameValidator, readPreference, commandResultDecoder, binding.getSessionContext(), binding.getServerApi(), new TransformingWriteResultCallback(transformer, connection, OperationHelper.releasingCallback(callback, source, connection)));
                    }
                });
            }
        };
    }

    static boolean isRetryableException(Throwable t) {
        if (!(t instanceof MongoException)) {
            return false;
        }
        if (t instanceof MongoSocketException || t instanceof MongoNotPrimaryException || t instanceof MongoNodeIsRecoveringException) {
            return true;
        }
        return RETRYABLE_ERROR_CODES.contains(((MongoException)t).getCode());
    }

    static void rethrowIfNotNamespaceError(MongoCommandException e) {
        CommandOperationHelper.rethrowIfNotNamespaceError(e, null);
    }

    static <T> T rethrowIfNotNamespaceError(MongoCommandException e, T defaultValue) {
        if (!CommandOperationHelper.isNamespaceError(e)) {
            throw e;
        }
        return defaultValue;
    }

    static boolean isNamespaceError(Throwable t) {
        if (t instanceof MongoCommandException) {
            MongoCommandException e = (MongoCommandException)t;
            return e.getErrorMessage().contains("ns not found") || e.getErrorCode() == 26;
        }
        return false;
    }

    private static boolean shouldAttemptToRetryRead(boolean retryReadsEnabled, Throwable t) {
        return retryReadsEnabled && CommandOperationHelper.isRetryableException(t);
    }

    private static boolean shouldAttemptToRetryWrite(@Nullable BsonDocument command, Throwable t, int maxWireVersion) {
        return CommandOperationHelper.shouldAttemptToRetryWrite(CommandOperationHelper.isRetryWritesEnabled(command), t, maxWireVersion);
    }

    private static boolean isRetryWritesEnabled(@Nullable BsonDocument command) {
        return command != null && (command.containsKey("txnNumber") || command.getFirstKey().equals("commitTransaction") || command.getFirstKey().equals("abortTransaction"));
    }

    static boolean shouldAttemptToRetryWrite(boolean retryWritesEnabled, Throwable t, int maxWireVersion) {
        if (!retryWritesEnabled) {
            return false;
        }
        if (!(t instanceof MongoException)) {
            return false;
        }
        MongoException exception = (MongoException)t;
        CommandOperationHelper.addRetryableWriteErrorLabel(exception, maxWireVersion);
        return exception.hasErrorLabel(RETRYABLE_WRITE_ERROR_LABEL);
    }

    static void addRetryableWriteErrorLabel(MongoException exception, int maxWireVersion) {
        if (maxWireVersion >= 9 && exception instanceof MongoSocketException) {
            exception.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
        } else if (maxWireVersion < 9 && CommandOperationHelper.isRetryableException(exception)) {
            exception.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
        }
    }

    static void logRetryExecute(String operation, Throwable originalError) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            OperationHelper.LOGGER.debug(String.format("Retrying operation %s due to an error \"%s\"", operation, originalError));
        }
    }

    static void logUnableToRetry(String operation, Throwable originalError) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            OperationHelper.LOGGER.debug(String.format("Unable to retry operation %s due to error \"%s\"", operation, originalError));
        }
    }

    static MongoException transformWriteException(MongoException exception) {
        if (exception.getCode() == 20 && exception.getMessage().contains("Transaction numbers")) {
            MongoClientException clientException = new MongoClientException("This MongoDB deployment does not support retryable writes. Please add retryWrites=false to your connection string.", exception);
            for (String errorLabel : exception.getErrorLabels()) {
                clientException.addLabel(errorLabel);
            }
            return clientException;
        }
        return exception;
    }

    private CommandOperationHelper() {
    }

    static class TransformingWriteResultCallback<T, R>
    implements SingleResultCallback<T> {
        private final CommandWriteTransformerAsync<T, R> transformer;
        private final AsyncConnection connection;
        private final SingleResultCallback<R> callback;

        TransformingWriteResultCallback(CommandWriteTransformerAsync<T, R> transformer, AsyncConnection connection, SingleResultCallback<R> callback) {
            this.transformer = transformer;
            this.connection = connection;
            this.callback = callback;
        }

        @Override
        public void onResult(T result, Throwable t) {
            if (t != null) {
                if (t instanceof MongoException) {
                    CommandOperationHelper.addRetryableWriteErrorLabel((MongoException)t, this.connection.getDescription().getMaxWireVersion());
                }
                this.callback.onResult(null, t);
            } else {
                try {
                    R transformedResult = this.transformer.apply(result, this.connection);
                    this.callback.onResult(transformedResult, null);
                }
                catch (Throwable transformError) {
                    this.callback.onResult(null, transformError);
                }
            }
        }
    }

    static class TransformingReadResultCallback<T, R>
    implements SingleResultCallback<T> {
        private final CommandReadTransformerAsync<T, R> transformer;
        private final AsyncConnectionSource source;
        private final AsyncConnection connection;
        private final SingleResultCallback<R> callback;

        TransformingReadResultCallback(CommandReadTransformerAsync<T, R> transformer, AsyncConnectionSource source, AsyncConnection connection, SingleResultCallback<R> callback) {
            this.transformer = transformer;
            this.source = source;
            this.connection = connection;
            this.callback = callback;
        }

        @Override
        public void onResult(T result, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                try {
                    R transformedResult = this.transformer.apply(result, this.source, this.connection);
                    this.callback.onResult(transformedResult, null);
                }
                catch (Throwable transformError) {
                    this.callback.onResult(null, transformError);
                }
            }
        }
    }

    static interface CommandCreator {
        public BsonDocument create(ServerDescription var1, ConnectionDescription var2);
    }

    static class IdentityTransformerAsync<T>
    implements CommandReadTransformerAsync<T, T> {
        IdentityTransformerAsync() {
        }

        @Override
        public T apply(T t, AsyncConnectionSource source, AsyncConnection connection) {
            return t;
        }
    }

    static class IdentityWriteTransformerAsync<T>
    implements CommandWriteTransformerAsync<T, T> {
        IdentityWriteTransformerAsync() {
        }

        @Override
        public T apply(T t, AsyncConnection connection) {
            return t;
        }
    }

    static class IdentityWriteTransformer<T>
    implements CommandWriteTransformer<T, T> {
        IdentityWriteTransformer() {
        }

        @Override
        public T apply(T t, Connection connection) {
            return t;
        }
    }

    static class IdentityReadTransformer<T>
    implements CommandReadTransformer<T, T> {
        IdentityReadTransformer() {
        }

        @Override
        public T apply(T t, ConnectionSource source, Connection connection) {
            return t;
        }
    }

    static interface CommandReadTransformerAsync<T, R> {
        public R apply(T var1, AsyncConnectionSource var2, AsyncConnection var3);
    }

    static interface CommandWriteTransformerAsync<T, R> {
        public R apply(T var1, AsyncConnection var2);
    }

    static interface CommandWriteTransformer<T, R> {
        public R apply(T var1, Connection var2);
    }

    static interface CommandReadTransformer<T, R> {
        public R apply(T var1, ConnectionSource var2, Connection var3);
    }
}

