/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.AggregateOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.FindOperation;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.mongodb.reactivestreams.client.internal.WriteOperationThenCursorReadOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

final class AggregatePublisherImpl<T>
extends BatchCursorPublisher<T>
implements AggregatePublisher<T> {
    private final List<? extends Bson> pipeline;
    private final AggregationLevel aggregationLevel;
    private Boolean allowDiskUse;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private String comment;
    private Bson hint;
    private Bson variables;

    AggregatePublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, List<? extends Bson> pipeline, AggregationLevel aggregationLevel) {
        super(clientSession, mongoOperationPublisher);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.aggregationLevel = Assertions.notNull("aggregationLevel", aggregationLevel);
    }

    @Override
    public AggregatePublisher<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AggregatePublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public AggregatePublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregatePublisher<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public AggregatePublisher<T> bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public AggregatePublisher<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public AggregatePublisher<T> comment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public AggregatePublisher<T> hint(@Nullable Bson hint) {
        this.hint = hint;
        return this;
    }

    @Override
    public AggregatePublisher<T> let(@Nullable Bson variables) {
        this.variables = variables;
        return this;
    }

    @Override
    public Publisher<Void> toCollection() {
        BsonDocument lastPipelineStage = this.getLastPipelineStage();
        if (lastPipelineStage == null || !lastPipelineStage.containsKey("$out") && !lastPipelineStage.containsKey("$merge")) {
            throw new IllegalStateException("The last stage of the aggregation pipeline must be $out or $merge");
        }
        return this.getMongoOperationPublisher().createWriteOperationMono(this::getAggregateToCollectionOperation, this.getClientSession());
    }

    @Override
    public Publisher<Document> explain() {
        return this.publishExplain(Document.class, null);
    }

    @Override
    public Publisher<Document> explain(ExplainVerbosity verbosity) {
        return this.publishExplain(Document.class, Assertions.notNull("verbosity", verbosity));
    }

    @Override
    public <E> Publisher<E> explain(Class<E> explainResultClass) {
        return this.publishExplain(explainResultClass, null);
    }

    @Override
    public <E> Publisher<E> explain(Class<E> explainResultClass, ExplainVerbosity verbosity) {
        return this.publishExplain(explainResultClass, Assertions.notNull("verbosity", verbosity));
    }

    private <E> Publisher<E> publishExplain(Class<E> explainResultClass, @Nullable ExplainVerbosity verbosity) {
        Assertions.notNull("explainDocumentClass", explainResultClass);
        return this.getMongoOperationPublisher().createReadOperationMono(() -> this.asAggregateOperation(1).asAsyncExplainableOperation(verbosity, this.getCodecRegistry().get(explainResultClass)), this.getClientSession());
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int initialBatchSize) {
        MongoNamespace outNamespace = this.getOutNamespace();
        if (outNamespace != null) {
            AsyncWriteOperation<Void> aggregateToCollectionOperation = this.getAggregateToCollectionOperation();
            FindOptions findOptions = new FindOptions().collation(this.collation).batchSize(initialBatchSize);
            FindOperation findOperation = this.getOperations().find(outNamespace, new BsonDocument(), this.getDocumentClass(), findOptions);
            return new WriteOperationThenCursorReadOperation(aggregateToCollectionOperation, findOperation);
        }
        return this.asAggregateOperation(initialBatchSize);
    }

    private AggregateOperation<T> asAggregateOperation(int initialBatchSize) {
        return this.getOperations().aggregate(this.pipeline, this.getDocumentClass(), this.maxTimeMS, this.maxAwaitTimeMS, initialBatchSize, this.collation, this.hint, this.comment, this.variables, this.allowDiskUse, this.aggregationLevel);
    }

    private AsyncWriteOperation<Void> getAggregateToCollectionOperation() {
        return this.getOperations().aggregateToCollection(this.pipeline, this.maxTimeMS, this.allowDiskUse, this.bypassDocumentValidation, this.collation, this.hint, this.comment, this.variables, this.aggregationLevel);
    }

    @Nullable
    private BsonDocument getLastPipelineStage() {
        if (this.pipeline.isEmpty()) {
            return null;
        }
        Bson lastStage = Assertions.notNull("last pipeline stage", this.pipeline.get(this.pipeline.size() - 1));
        return lastStage.toBsonDocument(this.getDocumentClass(), this.getCodecRegistry());
    }

    @Nullable
    private MongoNamespace getOutNamespace() {
        BsonDocument lastPipelineStage = this.getLastPipelineStage();
        if (lastPipelineStage == null) {
            return null;
        }
        String databaseName = this.getNamespace().getDatabaseName();
        if (lastPipelineStage.containsKey("$out")) {
            if (lastPipelineStage.get("$out").isString()) {
                return new MongoNamespace(databaseName, lastPipelineStage.getString("$out").getValue());
            }
            if (lastPipelineStage.get("$out").isDocument()) {
                BsonDocument outDocument = lastPipelineStage.getDocument("$out");
                if (!outDocument.containsKey("db") || !outDocument.containsKey("coll")) {
                    throw new IllegalStateException("Cannot return a cursor when the value for $out stage is not a namespace document");
                }
                return new MongoNamespace(outDocument.getString("db").getValue(), outDocument.getString("coll").getValue());
            }
            throw new IllegalStateException("Cannot return a cursor when the value for $out stage is not a string or namespace document");
        }
        if (lastPipelineStage.containsKey("$merge")) {
            if (lastPipelineStage.isString("$merge")) {
                return new MongoNamespace(databaseName, lastPipelineStage.getString("$merge").getValue());
            }
            if (lastPipelineStage.isDocument("$merge")) {
                BsonDocument mergeDocument = lastPipelineStage.getDocument("$merge");
                if (mergeDocument.isDocument("into")) {
                    BsonDocument intoDocument = mergeDocument.getDocument("into");
                    return new MongoNamespace(intoDocument.getString("db", new BsonString(databaseName)).getValue(), intoDocument.getString("coll").getValue());
                }
                if (mergeDocument.isString("into")) {
                    return new MongoNamespace(databaseName, mergeDocument.getString("into").getValue());
                }
            } else {
                throw new IllegalStateException("Cannot return a cursor when the value for $merge stage is not a string or a document");
            }
        }
        return null;
    }
}

