/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ReadConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListCollectionsPublisher;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

final class ListCollectionsPublisherImpl<T>
extends BatchCursorPublisher<T>
implements ListCollectionsPublisher<T> {
    private final boolean collectionNamesOnly;
    private Bson filter;
    private long maxTimeMS;

    ListCollectionsPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, boolean collectionNamesOnly) {
        super(clientSession, mongoOperationPublisher.withReadConcern(ReadConcern.DEFAULT));
        this.collectionNamesOnly = collectionNamesOnly;
    }

    @Override
    public ListCollectionsPublisherImpl<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionsPublisherImpl<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ListCollectionsPublisherImpl<T> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int initialBatchSize) {
        return this.getOperations().listCollections(this.getNamespace().getDatabaseName(), this.getDocumentClass(), this.filter, this.collectionNamesOnly, initialBatchSize, this.maxTimeMS);
    }
}

