/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListIndexesPublisher;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.concurrent.TimeUnit;

final class ListIndexesPublisherImpl<T>
extends BatchCursorPublisher<T>
implements ListIndexesPublisher<T> {
    private long maxTimeMS;

    ListIndexesPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher) {
        super(clientSession, mongoOperationPublisher);
    }

    @Override
    public ListIndexesPublisherImpl<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListIndexesPublisherImpl<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int initialBatchSize) {
        return this.getOperations().listIndexes(this.getDocumentClass(), initialBatchSize, this.maxTimeMS);
    }
}

