/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import java.io.Closeable;
import java.util.Map;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;
import reactor.core.publisher.Mono;

class CommandMarker
implements Closeable {
    private final ProcessBuilder processBuilder;
    private final MongoClient client;

    CommandMarker(boolean isBypassAutoEncryption, Map<String, Object> options) {
        if (isBypassAutoEncryption) {
            this.processBuilder = null;
            this.client = null;
        } else {
            if (!options.containsKey("mongocryptdBypassSpawn") || !((Boolean)options.get("mongocryptdBypassSpawn")).booleanValue()) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder(options);
                MongoCryptHelper.startProcess(this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)options.get("mongocryptdURI")));
        }
    }

    Mono<RawBsonDocument> mark(String databaseName, RawBsonDocument command) {
        if (this.client != null) {
            return this.runCommand(databaseName, command).onErrorResume(Throwable.class, e -> {
                if (this.processBuilder == null) {
                    throw MongoException.fromThrowable(e);
                }
                return Mono.fromRunnable(() -> MongoCryptHelper.startProcess(this.processBuilder)).then(this.runCommand(databaseName, command));
            }).onErrorMap(t -> new MongoClientException("Exception in encryption library: " + t.getMessage(), (Throwable)t));
        }
        return Mono.fromCallable(() -> command);
    }

    private Mono<RawBsonDocument> runCommand(String databaseName, RawBsonDocument command) {
        return Mono.from(this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)command, RawBsonDocument.class));
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

