/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.mongodb.reactivestreams.client.internal.crypt.CryptConnection;

public class CryptBinding
implements AsyncClusterAwareReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final Crypt crypt;

    public CryptBinding(AsyncClusterAwareReadWriteBinding wrapped, Crypt crypt) {
        this.wrapped = wrapped;
        this.crypt = crypt;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getWriteConnectionSource((result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(new CryptConnectionSource((AsyncConnectionSource)result), null);
            }
        });
    }

    @Override
    public SessionContext getSessionContext() {
        return this.wrapped.getSessionContext();
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.wrapped.getServerApi();
    }

    @Override
    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource((result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(new CryptConnectionSource((AsyncConnectionSource)result), null);
            }
        });
    }

    @Override
    public void getConnectionSource(ServerAddress serverAddress, SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getConnectionSource(serverAddress, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(new CryptConnectionSource((AsyncConnectionSource)result), null);
            }
        });
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public AsyncReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public void release() {
        this.wrapped.release();
    }

    @Override
    public Cluster getCluster() {
        return this.wrapped.getCluster();
    }

    private class CryptConnectionSource
    implements AsyncConnectionSource {
        private final AsyncConnectionSource wrapped;

        CryptConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
            CryptBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return this.wrapped.getSessionContext();
        }

        @Override
        @Nullable
        public ServerApi getServerApi() {
            return this.wrapped.getServerApi();
        }

        @Override
        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            this.wrapped.getConnection((result, t) -> {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new CryptConnection((AsyncConnection)result, CryptBinding.this.crypt), null);
                }
            });
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public AsyncConnectionSource retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public void release() {
            this.wrapped.release();
        }
    }
}

