/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.MongoSocketException;
import com.mongodb.ServerAddress;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.Stream;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.TlsChannelStreamFactoryFactory;
import com.mongodb.crypt.capi.MongoKeyDecryptor;
import com.mongodb.internal.connection.AsynchronousChannelStream;
import java.io.Closeable;
import java.nio.channels.CompletionHandler;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class KeyManagementService
implements Closeable {
    private final int defaultPort;
    private final TlsChannelStreamFactoryFactory tlsChannelStreamFactoryFactory;
    private final StreamFactory streamFactory;

    KeyManagementService(SSLContext sslContext, int defaultPort, int timeoutMillis) {
        this.defaultPort = defaultPort;
        this.tlsChannelStreamFactoryFactory = new TlsChannelStreamFactoryFactory();
        this.streamFactory = this.tlsChannelStreamFactoryFactory.create(SocketSettings.builder().connectTimeout(timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(timeoutMillis, TimeUnit.MILLISECONDS).build(), SslSettings.builder().enabled(true).context(sslContext).build());
    }

    @Override
    public void close() {
        this.tlsChannelStreamFactoryFactory.close();
    }

    Mono<Void> decryptKey(final MongoKeyDecryptor keyDecryptor) {
        return Mono.create(sink -> {
            ServerAddress serverAddress = keyDecryptor.getHostName().contains(":") ? new ServerAddress(keyDecryptor.getHostName()) : new ServerAddress(keyDecryptor.getHostName(), this.defaultPort);
            final Stream stream = this.streamFactory.create(serverAddress);
            stream.openAsync(new AsyncCompletionHandler<Void>(){

                @Override
                public void completed(Void ignored) {
                    KeyManagementService.this.streamWrite(stream, keyDecryptor, sink);
                }

                @Override
                public void failed(Throwable t) {
                    stream.close();
                    sink.error(t);
                }
            });
        }).onErrorMap(this::unWrapException);
    }

    private void streamWrite(final Stream stream, final MongoKeyDecryptor keyDecryptor, final MonoSink<Void> sink) {
        List<ByteBuf> byteBufs = Collections.singletonList(new ByteBufNIO(keyDecryptor.getMessage()));
        stream.writeAsync(byteBufs, new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(Void aVoid) {
                KeyManagementService.this.streamRead(stream, keyDecryptor, sink);
            }

            @Override
            public void failed(Throwable t) {
                stream.close();
                sink.error(t);
            }
        });
    }

    private void streamRead(final Stream stream, final MongoKeyDecryptor keyDecryptor, final MonoSink<Void> sink) {
        int bytesNeeded = keyDecryptor.bytesNeeded();
        if (bytesNeeded > 0) {
            AsynchronousChannelStream asyncStream = (AsynchronousChannelStream)stream;
            final ByteBuf buffer = asyncStream.getBuffer(bytesNeeded);
            asyncStream.getChannel().read(buffer.asNIO(), asyncStream.getSettings().getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, null, new CompletionHandler<Integer, Void>(){

                @Override
                public void completed(Integer integer, Void aVoid) {
                    buffer.flip();
                    try {
                        keyDecryptor.feed(buffer.asNIO());
                        buffer.release();
                        KeyManagementService.this.streamRead(stream, keyDecryptor, sink);
                    }
                    catch (Throwable t) {
                        sink.error(t);
                    }
                }

                @Override
                public void failed(Throwable t, Void aVoid) {
                    buffer.release();
                    stream.close();
                    sink.error(t);
                }
            });
        } else {
            stream.close();
            sink.success();
        }
    }

    private Throwable unWrapException(Throwable t) {
        return t instanceof MongoSocketException ? t.getCause() : t;
    }
}

