/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import com.mongodb.reactivestreams.client.internal.gridfs.GridFSDownloadPublisherImpl;
import com.mongodb.reactivestreams.client.internal.gridfs.GridFSFindPublisherImpl;
import com.mongodb.reactivestreams.client.internal.gridfs.GridFSUploadPublisherImpl;
import java.nio.ByteBuffer;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class GridFSPublisherCreator {
    private GridFSPublisherCreator() {
    }

    public static GridFSUploadPublisherImpl createGridFSUploadPublisher(int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options, Publisher<ByteBuffer> source) {
        Assertions.notNull("filesCollection", filesCollection);
        Assertions.notNull("chunksCollection", chunksCollection);
        Assertions.notNull("id", id);
        Assertions.notNull("filename", filename);
        Assertions.notNull("options", options);
        Integer chunkSize = options.getChunkSizeBytes();
        if (chunkSize == null) {
            chunkSize = chunkSizeBytes;
        }
        return new GridFSUploadPublisherImpl(clientSession, filesCollection, chunksCollection, id, filename, chunkSize, options.getMetadata(), source);
    }

    public static GridFSDownloadPublisherImpl createGridFSDownloadPublisher(MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession, GridFSFindPublisher publisher) {
        Assertions.notNull("chunksCollection", chunksCollection);
        Assertions.notNull("publisher", publisher);
        return new GridFSDownloadPublisherImpl(clientSession, Mono.from(publisher), chunksCollection);
    }

    public static GridFSFindPublisher createGridFSFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, @Nullable Bson filter) {
        Assertions.notNull("filesCollection", filesCollection);
        return new GridFSFindPublisherImpl(GridFSPublisherCreator.createFindPublisher(filesCollection, clientSession, filter));
    }

    public static GridFSFindPublisher createGridFSFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, String filename, GridFSDownloadOptions options) {
        int sort;
        int skip;
        Assertions.notNull("filesCollection", filesCollection);
        Assertions.notNull("filename", filename);
        Assertions.notNull("options", options);
        int revision = options.getRevision();
        if (revision >= 0) {
            skip = revision;
            sort = 1;
        } else {
            skip = -revision - 1;
            sort = -1;
        }
        return GridFSPublisherCreator.createGridFSFindPublisher(filesCollection, clientSession, new Document("filename", filename)).skip(skip).sort(new Document("uploadDate", sort));
    }

    public static FindPublisher<GridFSFile> createFindPublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, @Nullable Bson filter) {
        Assertions.notNull("filesCollection", filesCollection);
        FindPublisher<GridFSFile> publisher = clientSession == null ? filesCollection.find() : filesCollection.find(clientSession);
        if (filter != null) {
            publisher = publisher.filter(filter);
        }
        return publisher;
    }

    public static Publisher<Void> createDeletePublisher(MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession, BsonValue id) {
        Assertions.notNull("filesCollection", filesCollection);
        Assertions.notNull("chunksCollection", chunksCollection);
        Assertions.notNull("id", id);
        BsonDocument filter = new BsonDocument("_id", id);
        Publisher<DeleteResult> fileDeletePublisher = clientSession == null ? filesCollection.deleteOne(filter) : filesCollection.deleteOne(clientSession, filter);
        return Mono.from(fileDeletePublisher).flatMap(deleteResult -> {
            if (deleteResult.wasAcknowledged() && deleteResult.getDeletedCount() == 0L) {
                throw new MongoGridFSException(String.format("No file found with the ObjectId: %s", id));
            }
            if (clientSession == null) {
                return Mono.from(chunksCollection.deleteMany(new BsonDocument("files_id", id)));
            }
            return Mono.from(chunksCollection.deleteMany(clientSession, new BsonDocument("files_id", id)));
        }).flatMap(i -> Mono.empty());
    }

    public static Publisher<Void> createRenamePublisher(MongoCollection<GridFSFile> filesCollection, @Nullable ClientSession clientSession, BsonValue id, String newFilename) {
        Assertions.notNull("filesCollection", filesCollection);
        Assertions.notNull("id", id);
        Assertions.notNull("newFilename", newFilename);
        BsonDocument filter = new BsonDocument("_id", id);
        BsonDocument update = new BsonDocument("$set", new BsonDocument("filename", new BsonString(newFilename)));
        Publisher<UpdateResult> publisher = clientSession == null ? filesCollection.updateOne((Bson)filter, update) : filesCollection.updateOne(clientSession, (Bson)filter, update);
        return Mono.from(publisher).flatMap(updateResult -> {
            if (updateResult.wasAcknowledged() && updateResult.getModifiedCount() == 0L) {
                throw new MongoGridFSException(String.format("No file found with the ObjectId: %s", id));
            }
            return Mono.empty();
        });
    }

    public static Publisher<Void> createDropPublisher(MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection, @Nullable ClientSession clientSession) {
        Publisher<Void> filesDropPublisher = clientSession == null ? filesCollection.drop() : filesCollection.drop(clientSession);
        Publisher<Void> chunksDropPublisher = clientSession == null ? chunksCollection.drop() : chunksCollection.drop(clientSession);
        return Mono.from(filesDropPublisher).then(Mono.from(chunksDropPublisher));
    }
}

