/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt;

import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.Module;
import com.schibsted.spt.data.jslt.ResourceResolver;
import com.schibsted.spt.data.jslt.filters.DefaultJsonFilter;
import com.schibsted.spt.data.jslt.filters.JsltJsonFilter;
import com.schibsted.spt.data.jslt.filters.JsonFilter;
import com.schibsted.spt.data.jslt.impl.ClasspathResourceResolver;
import com.schibsted.spt.data.jslt.impl.JstlFile;
import com.schibsted.spt.data.jslt.impl.ParseContext;
import com.schibsted.spt.data.jslt.impl.PreparationContext;
import com.schibsted.spt.data.jslt.parser.JsltParser;
import com.schibsted.spt.data.jslt.parser.ParserImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Parser {
    private Collection<Function> functions;
    private String source;
    private Reader reader;
    private ResourceResolver resolver;
    private Map<String, Module> modules;
    private JsonFilter objectFilter;

    public static Expression compile(File jslt) {
        return Parser.compile(jslt, Collections.EMPTY_SET);
    }

    public static Expression compile(File jslt, Collection<Function> functions) {
        Expression expression;
        FileReader f = new FileReader(jslt);
        try {
            expression = new Parser(f).withSource(jslt.getAbsolutePath()).withFunctions(functions).compile();
        }
        catch (Throwable throwable) {
            try {
                try {
                    f.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new JsltException("Couldn't find file " + jslt);
            }
            catch (IOException e) {
                throw new JsltException("Couldn't read file " + jslt, e);
            }
        }
        f.close();
        return expression;
    }

    public static Expression compileString(String jslt) {
        return Parser.compileString(jslt, Collections.EMPTY_SET);
    }

    public static Expression compileString(String jslt, Collection<Function> functions) {
        return new Parser(new StringReader(jslt)).withSource("<inline>").withFunctions(functions).compile();
    }

    public static Expression compileResource(String jslt) {
        return Parser.compileResource(jslt, Collections.EMPTY_SET);
    }

    public static Expression compileResource(String jslt, Collection<Function> functions) {
        Expression expression;
        block9: {
            InputStream stream = Parser.class.getClassLoader().getResourceAsStream(jslt);
            try {
                if (stream == null) {
                    throw new JsltException("Cannot load resource '" + jslt + "': not found");
                }
                InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
                expression = new Parser(reader).withSource(jslt).withFunctions(functions).compile();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JsltException("Couldn't read resource " + jslt, e);
                }
            }
            stream.close();
        }
        return expression;
    }

    public static Expression compile(String source, Reader reader, Collection<Function> functions) {
        return new Parser(reader).withSource(source).withFunctions(functions).compile();
    }

    private Parser(String source, Reader reader, Collection<Function> functions, ResourceResolver resolver, Map<String, Module> modules, JsonFilter filter) {
        this.functions = functions;
        this.source = source;
        this.reader = reader;
        this.resolver = resolver;
        this.modules = modules;
        this.objectFilter = filter;
    }

    public Parser(Reader reader) {
        this("<unknown>", reader, Collections.EMPTY_SET, new ClasspathResourceResolver(), new HashMap<String, Module>(), new DefaultJsonFilter());
    }

    public Parser withSource(String thisSource) {
        return new Parser(thisSource, this.reader, this.functions, this.resolver, this.modules, this.objectFilter);
    }

    public Parser withFunctions(Collection<Function> theseFunctions) {
        return new Parser(this.source, this.reader, theseFunctions, this.resolver, this.modules, this.objectFilter);
    }

    public Parser withResourceResolver(ResourceResolver thisResolver) {
        return new Parser(this.source, this.reader, this.functions, thisResolver, this.modules, this.objectFilter);
    }

    public Parser withNamedModules(Map<String, Module> thisModules) {
        return new Parser(this.source, this.reader, this.functions, this.resolver, thisModules, this.objectFilter);
    }

    public Parser withObjectFilter(String filter) {
        Expression parsedFilter = Parser.compileString(filter);
        return new Parser(this.source, this.reader, this.functions, this.resolver, this.modules, new JsltJsonFilter(parsedFilter));
    }

    public Parser withObjectFilter(JsonFilter filter) {
        return new Parser(this.source, this.reader, this.functions, this.resolver, this.modules, filter);
    }

    public Expression compile() {
        ParseContext ctx = new ParseContext(this.functions, this.source, this.resolver, this.modules, new ArrayList<JstlFile>(), new PreparationContext(), this.objectFilter);
        return ParserImpl.compileExpression(ctx, new JsltParser(this.reader));
    }
}

