/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.JsltException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class FunctionWrapper
implements Function {
    private String name;
    private Method method;
    private ToJavaConverter[] converters;
    private ToJsonConverter returnConverter;
    private static Map<Class, ToJavaConverter> toJava = new HashMap<Class, ToJavaConverter>();
    private static Map<Class, ToJsonConverter> toJson;

    public FunctionWrapper(String name, Method method) {
        this.name = name;
        this.method = method;
        this.returnConverter = FunctionWrapper.makeJsonConverter(method.getReturnType());
        Class<?>[] paramTypes = method.getParameterTypes();
        this.converters = new ToJavaConverter[paramTypes.length];
        for (int ix = 0; ix < paramTypes.length; ++ix) {
            this.converters[ix] = FunctionWrapper.makeJavaConverter(paramTypes[ix]);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMinArguments() {
        return this.method.getParameterCount();
    }

    @Override
    public int getMaxArguments() {
        return this.method.getParameterCount();
    }

    @Override
    public JsonNode call(JsonNode input, JsonNode[] arguments) {
        Object[] args = new Object[arguments.length];
        for (int ix = 0; ix < arguments.length; ++ix) {
            args[ix] = this.converters[ix].convert(arguments[ix]);
        }
        try {
            Object result = this.method.invoke(null, args);
            return this.returnConverter.convert(result);
        }
        catch (IllegalAccessException e) {
            throw new JsltException("Couldn't call " + this.method, e);
        }
        catch (InvocationTargetException e) {
            throw new JsltException("Couldn't call " + this.method, e);
        }
    }

    private static ToJavaConverter makeJavaConverter(Class type) {
        ToJavaConverter converter = toJava.get(type);
        if (converter == null) {
            throw new JsltException("Cannot build converter to " + type);
        }
        return converter;
    }

    private static ToJsonConverter makeJsonConverter(Class type) {
        ToJsonConverter converter = toJson.get(type);
        if (converter == null) {
            throw new JsltException("Cannot build converter from " + type);
        }
        return converter;
    }

    static {
        toJava.put(String.class, new StringJavaConverter());
        toJava.put(Integer.TYPE, new IntJavaConverter());
        toJava.put(Long.TYPE, new LongJavaConverter());
        toJava.put(Boolean.TYPE, new BooleanJavaConverter());
        toJava.put(Double.TYPE, new DoubleJavaConverter());
        toJava.put(Float.TYPE, new DoubleJavaConverter());
        toJson = new HashMap<Class, ToJsonConverter>();
        toJson.put(String.class, new StringJsonConverter());
        toJson.put(Long.TYPE, new LongJsonConverter());
        toJson.put(Integer.TYPE, new IntJsonConverter());
        toJson.put(Boolean.TYPE, new BooleanJsonConverter());
        toJson.put(Double.TYPE, new DoubleJsonConverter());
        toJson.put(Float.TYPE, new FloatJsonConverter());
    }

    static class FloatJsonConverter
    implements ToJsonConverter {
        FloatJsonConverter() {
        }

        @Override
        public JsonNode convert(Object node) {
            if (node == null) {
                return NullNode.instance;
            }
            return new FloatNode(((Float)node).floatValue());
        }
    }

    static class DoubleJsonConverter
    implements ToJsonConverter {
        DoubleJsonConverter() {
        }

        @Override
        public JsonNode convert(Object node) {
            if (node == null) {
                return NullNode.instance;
            }
            return new DoubleNode((Double)node);
        }
    }

    static class BooleanJsonConverter
    implements ToJsonConverter {
        BooleanJsonConverter() {
        }

        @Override
        public JsonNode convert(Object node) {
            if (node == null) {
                return NullNode.instance;
            }
            if (((Boolean)node).booleanValue()) {
                return BooleanNode.TRUE;
            }
            return BooleanNode.FALSE;
        }
    }

    static class IntJsonConverter
    implements ToJsonConverter {
        IntJsonConverter() {
        }

        @Override
        public JsonNode convert(Object node) {
            if (node == null) {
                return NullNode.instance;
            }
            return new IntNode((Integer)node);
        }
    }

    static class LongJsonConverter
    implements ToJsonConverter {
        LongJsonConverter() {
        }

        @Override
        public JsonNode convert(Object node) {
            if (node == null) {
                return NullNode.instance;
            }
            return new LongNode((Long)node);
        }
    }

    static class StringJsonConverter
    implements ToJsonConverter {
        StringJsonConverter() {
        }

        @Override
        public JsonNode convert(Object node) {
            if (node == null) {
                return NullNode.instance;
            }
            return new TextNode((String)node);
        }
    }

    static interface ToJsonConverter {
        public JsonNode convert(Object var1);
    }

    static class DoubleJavaConverter
    implements ToJavaConverter {
        DoubleJavaConverter() {
        }

        @Override
        public Object convert(JsonNode node) {
            if (!node.isNumber()) {
                throw new JsltException("Cannot convert " + node + " to double");
            }
            return node.asDouble();
        }
    }

    static class BooleanJavaConverter
    implements ToJavaConverter {
        BooleanJavaConverter() {
        }

        @Override
        public Object convert(JsonNode node) {
            if (!node.isBoolean()) {
                throw new JsltException("Cannot convert " + node + " to boolean");
            }
            return node.asBoolean();
        }
    }

    static class IntJavaConverter
    implements ToJavaConverter {
        IntJavaConverter() {
        }

        @Override
        public Object convert(JsonNode node) {
            if (!node.isNumber()) {
                throw new JsltException("Cannot convert " + node + " to int");
            }
            return node.asInt();
        }
    }

    static class LongJavaConverter
    implements ToJavaConverter {
        LongJavaConverter() {
        }

        @Override
        public Object convert(JsonNode node) {
            if (!node.isNumber()) {
                throw new JsltException("Cannot convert " + node + " to long");
            }
            return node.asLong();
        }
    }

    static class StringJavaConverter
    implements ToJavaConverter {
        StringJavaConverter() {
        }

        @Override
        public Object convert(JsonNode node) {
            if (node.isNull()) {
                return null;
            }
            if (node.isTextual()) {
                return node.asText();
            }
            throw new JsltException("Could not convert " + node + " to string");
        }
    }

    static interface ToJavaConverter {
        public Object convert(JsonNode var1);
    }
}

