/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.cls;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.pincette.cls.Attribute;
import net.pincette.cls.Code;
import net.pincette.cls.ExceptionHandler;
import net.pincette.cls.Field;
import net.pincette.cls.LocalVariable;
import net.pincette.cls.Method;
import net.pincette.cls.NotAClassException;
import net.pincette.cls.Util;
import net.pincette.util.Pair;
import net.pincette.util.StreamUtil;

public class ClassFile {
    private static final byte CONSTANT_CLASS = 7;
    private static final byte CONSTANT_FIELDREF = 9;
    private static final byte CONSTANT_METHODREF = 10;
    private static final byte CONSTANT_INTERFACE_METHODREF = 11;
    private static final byte CONSTANT_STRING = 8;
    private static final byte CONSTANT_INTEGER = 3;
    private static final byte CONSTANT_FLOAT = 4;
    private static final byte CONSTANT_LONG = 5;
    private static final byte CONSTANT_DOUBLE = 6;
    private static final byte CONSTANT_NAME_AND_TYPE = 12;
    private static final byte CONSTANT_UTF_8 = 1;
    private static final String DEPRECATED = "Deprecated";
    private static final Object EMPTY = new Object();
    private Attribute[] attributes;
    private Object[] constantPool;
    private Field[] fields;
    private String[] interfaces;
    private boolean isDeprecated;
    private Method[] methods;
    private int modifiers;
    private String name;
    private String sourceFile;
    private String superClass;
    private String version;

    private ClassFile() {
    }

    private static boolean isDoubleTag(byte tag) {
        return tag == 6 || tag == 5;
    }

    private static ClassFile parse(DataInputStream in) throws IOException {
        if (in.readInt() != -889275714) {
            throw new NotAClassException();
        }
        ClassFile c = new ClassFile();
        c.version = String.valueOf(in.readShort());
        c.version = String.valueOf(in.readShort()) + "." + c.version;
        c.constantPool = ClassFile.readConstantPool(in, in.readShort());
        c.modifiers = in.readShort();
        c.name = c.getClassName(in.readShort());
        short superClass = in.readShort();
        c.superClass = superClass == 0 ? null : c.getClassName(superClass);
        c.interfaces = c.readClassNames(in, in.readShort());
        c.fields = c.readFields(in, in.readShort());
        c.methods = c.readMethods(in, in.readShort());
        short attLength = in.readShort();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (short i = 0; i < attLength; i = (short)(i + 1)) {
            String name = (String)c.constantPool[in.readShort()];
            int length = in.readInt();
            if (name.equals(DEPRECATED)) {
                c.isDeprecated = true;
                continue;
            }
            if (name.equals("SourceFile")) {
                c.sourceFile = (String)c.constantPool[in.readShort()];
                continue;
            }
            attributes.add(c.readAttribute(in, name, length));
        }
        c.attributes = attributes.toArray(new Attribute[attributes.size()]);
        c.constantPool = null;
        return c;
    }

    public static ClassFile parse(InputStream in) throws IOException {
        return ClassFile.parse(new DataInputStream(in));
    }

    public static ClassFile parse(byte[] b) throws IOException {
        return ClassFile.parse(new ByteArrayInputStream(b));
    }

    private static Object[] readConstantPool(DataInput in, short size) {
        return StreamUtil.takeWhile(ClassFile.readConstantPoolEntry(in, 1, size), pair -> ClassFile.readConstantPoolEntry(in, (Integer)pair.first + 1, size), pair -> (Integer)pair.first < size).flatMap(pair -> (Stream)pair.second).map(o -> o == EMPTY ? null : Integer.valueOf(0)).toArray();
    }

    private static Pair<Integer, Stream<Object>> readConstantPoolEntry(DataInput in, int index, short size) {
        Function<Byte, Stream> addExtra = tag -> ClassFile.isDoubleTag(tag) ? Stream.of(EMPTY) : Stream.empty();
        ToIntFunction<Byte> moveExtra = tag -> ClassFile.isDoubleTag(tag) ? 1 : 0;
        return index < size ? (Pair)net.pincette.util.Util.tryToGetRethrow(in::readByte).map(tag -> Pair.pair(index + 1 + moveExtra.applyAsInt((Byte)tag), Stream.concat(Stream.of(net.pincette.util.Util.tryToGetRethrow(() -> ClassFile.readConstantPoolEntry(in, tag)).orElse(null)), (Stream)addExtra.apply((Byte)tag)))).orElse(null) : Pair.pair(index + 1, null);
    }

    private static Object readConstantPoolEntry(DataInput in, byte tag) throws IOException {
        switch (tag) {
            case 7: {
                return new ClassInfo(in.readShort());
            }
            case 9: 
            case 10: 
            case 11: {
                return new RefInfo(tag, in.readShort(), in.readShort());
            }
            case 8: {
                return new StringInfo(in.readShort());
            }
            case 3: {
                return in.readInt();
            }
            case 4: {
                return Float.valueOf(in.readFloat());
            }
            case 5: {
                return in.readLong();
            }
            case 6: {
                return in.readDouble();
            }
            case 12: {
                return new NameAndType(in.readShort(), in.readShort());
            }
            case 1: {
                return ClassFile.readString(in);
            }
        }
        return null;
    }

    private static String readString(DataInput in) throws IOException {
        byte[] b = new byte[in.readShort()];
        in.readFully(b);
        return net.pincette.util.Util.tryToGetRethrow(() -> new String(b, StandardCharsets.UTF_8)).orElse(null);
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    private String getClassName(short index) {
        return (String)this.constantPool[((ClassInfo)this.constantPool[index]).name];
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String[] getInterfaceNames() {
        return this.interfaces;
    }

    public String[] getInterfaceTypes() {
        String[] result = new String[this.interfaces.length];
        for (int i = 0; i < this.interfaces.length; ++i) {
            result[i] = Util.getType(this.interfaces[i]);
        }
        return result;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getSuperClassName() {
        return this.superClass;
    }

    public String getSuperClassType() {
        return this.superClass == null ? null : Util.getType(this.superClass);
    }

    public String getType() {
        return Util.getType(this.name);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isArray() {
        return this.name.charAt(0) == '[';
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    private Attribute readAttribute(DataInput in, String name, int length) throws IOException {
        Attribute attribute = new Attribute();
        attribute.name = name;
        attribute.value = new byte[length];
        in.readFully(attribute.value);
        return attribute;
    }

    private String[] readClassNames(DataInput in, short size) throws IOException {
        String[] result = new String[size];
        for (short i = 0; i < size; i = (short)(i + 1)) {
            result[i] = this.getClassName(in.readShort());
        }
        return result;
    }

    private Code readCode(DataInput in) throws IOException {
        Code result = new Code();
        result.maxStack = in.readShort();
        result.maxLocals = in.readShort();
        result.theCode = new byte[in.readInt()];
        in.readFully(result.theCode);
        result.exceptions = this.readExceptionHandlers(in, in.readShort());
        short attLength = in.readShort();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        ArrayList<LocalVariable> localVariables = new ArrayList<LocalVariable>();
        for (short i = 0; i < attLength; i = (short)(i + 1)) {
            String nam = (String)this.constantPool[in.readShort()];
            int length = in.readInt();
            if (nam.equals("LocalVariableTable")) {
                localVariables.addAll(this.readLocalVariables(in, in.readShort()));
                continue;
            }
            atts.add(this.readAttribute(in, nam, length));
        }
        result.attributes = atts.toArray(new Attribute[atts.size()]);
        localVariables.sort(Comparator.comparing(LocalVariable::getIndex));
        result.localVariables = localVariables.toArray(new LocalVariable[0]);
        return result;
    }

    private ExceptionHandler[] readExceptionHandlers(DataInput in, short size) throws IOException {
        ExceptionHandler[] result = new ExceptionHandler[size];
        for (short i = 0; i < size; i = (short)(i + 1)) {
            result[i] = new ExceptionHandler();
            result[i].startPC = in.readShort();
            result[i].endPC = in.readShort();
            result[i].handlerPC = in.readShort();
            short index = in.readShort();
            result[i].type = index == 0 ? null : this.getClassName(index);
        }
        return result;
    }

    private Field[] readFields(DataInput in, short size) throws IOException {
        Field[] result = new Field[size];
        for (int i = 0; i < size; ++i) {
            result[i] = new Field();
            result[i].modifiers = in.readShort();
            result[i].name = (String)this.constantPool[in.readShort()];
            result[i].descriptor = (String)this.constantPool[in.readShort()];
            short attLength = in.readShort();
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (short j = 0; j < attLength; j = (short)(j + 1)) {
                String nam = (String)this.constantPool[in.readShort()];
                int length = in.readInt();
                if (nam.equals("ConstantValue")) {
                    result[i].value = this.constantPool[in.readShort()];
                    continue;
                }
                if (nam.equals("Synthetic")) {
                    result[i].isSynthetic = true;
                    continue;
                }
                if (nam.equals(DEPRECATED)) {
                    result[i].isDeprecated = true;
                    continue;
                }
                atts.add(this.readAttribute(in, nam, length));
            }
            result[i].attributes = atts.toArray(new Attribute[atts.size()]);
        }
        return result;
    }

    private List<LocalVariable> readLocalVariables(DataInput in, short size) throws IOException {
        ArrayList<LocalVariable> result = new ArrayList<LocalVariable>();
        for (short i = 0; i < size; i = (short)(i + 1)) {
            LocalVariable localVariable = new LocalVariable();
            localVariable.startPC = in.readShort();
            localVariable.length = in.readShort();
            localVariable.name = (String)this.constantPool[in.readShort()];
            localVariable.descriptor = (String)this.constantPool[in.readShort()];
            localVariable.index = in.readShort();
            result.add(localVariable);
        }
        return result;
    }

    private Method[] readMethods(DataInput in, short size) throws IOException {
        Method[] result = new Method[size];
        for (short i = 0; i < size; i = (short)(i + 1)) {
            result[i] = new Method();
            result[i].modifiers = in.readShort();
            result[i].name = (String)this.constantPool[in.readShort()];
            result[i].descriptor = (String)this.constantPool[in.readShort()];
            result[i].exceptions = new String[0];
            result[i].className = this.name;
            short attLength = in.readShort();
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (short j = 0; j < attLength; j = (short)(j + 1)) {
                String nam = (String)this.constantPool[in.readShort()];
                int length = in.readInt();
                if (nam.equals("Code")) {
                    result[i].code = this.readCode(in);
                    continue;
                }
                if (nam.equals("Exceptions")) {
                    result[i].exceptions = this.readClassNames(in, in.readShort());
                    continue;
                }
                if (nam.equals("Synthetic")) {
                    result[i].isSynthetic = true;
                    continue;
                }
                if (nam.equals(DEPRECATED)) {
                    result[i].isDeprecated = true;
                    continue;
                }
                atts.add(this.readAttribute(in, nam, length));
            }
            result[i].attributes = atts.toArray(new Attribute[atts.size()]);
        }
        return result;
    }

    private static class StringInfo {
        short name;

        private StringInfo(short name) {
            this.name = name;
        }
    }

    private static class RefInfo {
        short classInfo;
        short nameAndType;
        byte tag;

        private RefInfo(byte tag, short classInfo, short nameAndType) {
            this.tag = tag;
            this.classInfo = classInfo;
            this.nameAndType = nameAndType;
        }
    }

    private static class NameAndType {
        short name;
        short type;

        private NameAndType(short name, short type) {
            this.name = name;
            this.type = type;
        }
    }

    private static class ClassInfo {
        private short name;

        private ClassInfo(short name) {
            this.name = name;
        }
    }
}

