/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.cls;

import java.util.regex.Pattern;
import net.pincette.cls.Attribute;
import net.pincette.cls.Code;
import net.pincette.cls.Util;

public class Method {
    private static final Pattern METHOD_PARAMETERS = Pattern.compile("\\[*(L[^;]+;|[ZBCSIFDJ])");
    Attribute[] attributes;
    String className;
    Code code;
    String descriptor;
    String[] exceptions;
    boolean isDeprecated;
    boolean isSynthetic;
    int modifiers;
    String name;

    public Attribute[] getAttribtutes() {
        return this.attributes;
    }

    public Code getCode() {
        return this.code;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String[] getExceptionNames() {
        return this.exceptions;
    }

    public String[] getExceptionTypes() {
        String[] result = new String[this.exceptions.length];
        for (int i = 0; i < this.exceptions.length; ++i) {
            result[i] = Util.getType(this.exceptions[i]);
        }
        return result;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.isConstructor() ? Util.getType(this.className).substring(Util.getType(this.className).lastIndexOf(46) + 1) : this.name;
    }

    public String[] getParameterTypes() {
        return (String[])METHOD_PARAMETERS.splitAsStream(this.descriptor.substring(1, this.descriptor.indexOf(41))).map(Util::getType).toArray(String[]::new);
    }

    public String getReturnType() {
        return Util.getType(this.descriptor.substring(this.descriptor.lastIndexOf(41) + 1));
    }

    public boolean isConstructor() {
        return this.name.equals("<init>");
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isInitializer() {
        return this.name.equals("<clinit>");
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }
}

