/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.cls;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import net.pincette.cls.ClassFile;
import net.pincette.cls.Field;
import net.pincette.cls.Method;

public class Writer {
    private Writer() {
    }

    private static String getConstructors(Method[] methods) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isConstructor() || methods[i].isSynthetic()) continue;
            result.append("  ").append(Writer.getModifiers(methods[i].getModifiers())).append("\n  ").append(methods[i].getName()).append(Writer.getParameters(methods[i])).append((String)(methods[i].getExceptionTypes().length > 0 ? "\n    " + Writer.getThrows(methods[i].getExceptionTypes()) : "")).append("\n  {\n  }\n\n");
        }
        return result.toString();
    }

    private static String getFields(Field[] fields) {
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].isSynthetic()) continue;
            result.append("  ").append(Writer.getModifiers(fields[i].getModifiers())).append(fields[i].getType()).append(' ').append(fields[i].getName()).append(";\n");
        }
        return result.toString();
    }

    private static String getMethods(Method[] methods, boolean isInterface) {
        Arrays.sort(methods, Comparator.comparing(Method::getName));
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].isConstructor() || methods[i].isInitializer() || methods[i].isSynthetic()) continue;
            result.append("  ").append(Writer.getModifiers(methods[i].getModifiers())).append(methods[i].getReturnType()).append("\n  ").append(methods[i].getName()).append(Writer.getParameters(methods[i])).append((String)(methods[i].getExceptionTypes().length > 0 ? "\n    " + Writer.getThrows(methods[i].getExceptionTypes()) : "")).append(isInterface || Modifier.isNative(methods[i].getModifiers()) ? ";\n\n" : "\n  {\n  }\n\n");
        }
        return result.toString();
    }

    private static String getModifiers(int modifiers) {
        return modifiers == 0 ? "" : Modifier.toString(modifiers) + " ";
    }

    private static String getParameters(Method method) {
        int staticCode = Modifier.isStatic(method.getModifiers()) ? 0 : 1;
        StringBuilder result = new StringBuilder();
        String[] types = method.getParameterTypes();
        result.append('(');
        for (int i = 0; i < types.length; ++i) {
            result.append(i > 0 ? ", " : "").append(types[i]).append(' ').append((String)(method.getCode() != null && method.getCode().getLocalVariables().length >= types.length ? method.getCode().getLocalVariables()[i + staticCode].getName() : "p" + i));
        }
        result.append(')');
        return result.toString();
    }

    private static String getThrows(String[] types) {
        if (types.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("throws ");
        for (int i = 0; i < types.length; ++i) {
            result.append(i > 0 ? ", " : "").append(types[i]);
        }
        return result.toString();
    }

    public static void write(java.io.Writer out, ClassFile c) throws IOException {
        String[] intfs;
        if (c.getType().indexOf(46) != -1) {
            out.write("package " + c.getType().substring(0, c.getType().lastIndexOf(46)) + ";\n\n");
        }
        int modifiers = c.getModifiers() & 0xFFFFFFDF;
        out.write(Writer.getModifiers(modifiers) + (c.isInterface() ? "" : "class ") + c.getType().substring(c.getType().lastIndexOf(46) + 1) + "\n");
        if (c.getSuperClassName() != null && !c.getSuperClassType().equals("java.lang.Object")) {
            out.write("  extends " + c.getSuperClassType() + "\n");
        }
        if ((intfs = c.getInterfaceTypes()).length > 0) {
            out.write("  " + (c.isInterface() ? "extends" : "implements") + "\n");
        }
        for (int i = 0; i < intfs.length; ++i) {
            out.write("    " + intfs[i] + (i < intfs.length - 1 ? ",\n" : "\n"));
        }
        out.write("{\n" + Writer.getFields(c.getFields()) + "\n" + Writer.getConstructors(c.getMethods()) + "\n" + Writer.getMethods(c.getMethods(), c.isInterface()) + "} // " + c.getType().substring(c.getType().lastIndexOf(46) + 1) + "\n");
    }
}

