/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class Base64InputStream
extends FilterInputStream {
    private static final byte[] values = Base64InputStream.createValues();
    private final byte[] decodedBuffer = new byte[3];
    private byte[] encodedBuffer = null;
    private int encodedPosition = 0;
    private int length = 0;
    private int quantumPosition = 0;

    public Base64InputStream(InputStream in) {
        super(in);
    }

    private static byte[] createValues() {
        byte j = 0;
        byte[] result = new byte[256];
        Arrays.fill(result, (byte)-1);
        int i = 65;
        while (i <= 90) {
            result[i] = j;
            ++i;
            j = (byte)(j + 1);
        }
        i = 97;
        while (i <= 122) {
            result[i] = j;
            ++i;
            j = (byte)(j + 1);
        }
        i = 48;
        while (i <= 57) {
            result[i] = j;
            ++i;
            j = (byte)(j + 1);
        }
        byte by = j;
        j = (byte)(j + 1);
        result[43] = by;
        result[47] = j;
        return result;
    }

    @Override
    public int available() {
        return 0;
    }

    private void checkQuantumPosition() {
        if (++this.quantumPosition == 4) {
            Arrays.fill(this.decodedBuffer, (byte)0);
            this.quantumPosition = 0;
        }
    }

    private int decodeQuantumPosition(byte[] b, int position, int off) {
        switch (this.quantumPosition) {
            case 0: {
                return this.decode0(position);
            }
            case 1: {
                return this.decode1(b, position, off);
            }
            case 2: {
                return this.decode2(b, position, off);
            }
            case 3: {
                return this.decode3(b, position, off);
            }
        }
        return position;
    }

    private int decode0(int position) {
        this.decodedBuffer[0] = (byte)(values[this.encodedBuffer[this.encodedPosition]] << 2);
        return position;
    }

    private int decode1(byte[] b, int position, int off) {
        this.decodedBuffer[0] = (byte)(this.decodedBuffer[0] | values[this.encodedBuffer[this.encodedPosition]] >> 4 & 3);
        this.decodedBuffer[1] = (byte)(values[this.encodedBuffer[this.encodedPosition]] << 4);
        b[position + off] = this.decodedBuffer[0];
        return position + 1;
    }

    private int decode2(byte[] b, int position, int off) {
        if (this.encodedBuffer[this.encodedPosition] != 61) {
            this.decodedBuffer[1] = (byte)(this.decodedBuffer[1] | values[this.encodedBuffer[this.encodedPosition]] >> 2 & 0xF);
            this.decodedBuffer[2] = (byte)(values[this.encodedBuffer[this.encodedPosition]] << 6);
            b[position + off] = this.decodedBuffer[1];
            return position + 1;
        }
        return position;
    }

    private int decode3(byte[] b, int position, int off) {
        if (this.encodedBuffer[this.encodedPosition] != 61) {
            this.decodedBuffer[2] = (byte)(this.decodedBuffer[2] | values[this.encodedBuffer[this.encodedPosition]]);
            b[position + off] = this.decodedBuffer[2];
            return position + 1;
        }
        return position;
    }

    private boolean prepareBuffer(int len) throws IOException {
        if (this.length == -1) {
            return false;
        }
        if (this.encodedBuffer == null || this.encodedPosition == this.length) {
            this.encodedBuffer = new byte[Math.max(2 * len, 4)];
            this.encodedPosition = 0;
            this.length = this.in.read(this.encodedBuffer);
            return this.length != -1;
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b, 0, b.length) == -1 ? -1 : 0xFF & b[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.prepareBuffer(len)) {
            return -1;
        }
        int i = 0;
        while (this.encodedPosition < this.length && i < len) {
            if (values[this.encodedBuffer[this.encodedPosition]] != -1 || this.encodedBuffer[this.encodedPosition] == 61) {
                i = this.decodeQuantumPosition(b, i, off);
                this.checkQuantumPosition();
            }
            ++this.encodedPosition;
        }
        return i < len ? this.readAdditional(b, i, off, len) : len;
    }

    private int readAdditional(byte[] b, int position, int off, int len) throws IOException {
        int initial = position == 0 ? -1 : position;
        int bytesRead = this.read(b, off + position, len - position);
        return bytesRead == -1 ? initial : position + bytesRead;
    }

    @Override
    public long skip(long n) {
        return 0L;
    }
}

