/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private static final byte[] alphabet = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private final byte[] buffer = new byte[3];
    private boolean closeUnderlying;
    private int lineSize = 0;
    private boolean oneLine;
    private int position = 0;

    public Base64OutputStream(OutputStream out) {
        this(out, false, true);
    }

    public Base64OutputStream(OutputStream out, boolean oneLine) {
        this(out, oneLine, true);
        this.oneLine = oneLine;
    }

    public Base64OutputStream(OutputStream out, boolean oneLine, boolean closeUnderlying) {
        super(out);
        this.oneLine = oneLine;
        this.closeUnderlying = closeUnderlying;
    }

    private int checkLine(byte[] b, int off) {
        if (++this.lineSize == 76) {
            this.lineSize = 0;
            b[off] = 13;
            b[off + 1] = 10;
            return 2;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.position > 0) {
            byte[] output = new byte[6];
            int len = this.encode(output, 0);
            this.out.write(output, 0, len);
        }
        this.out.flush();
        if (this.closeUnderlying) {
            this.out.close();
        }
    }

    private int encode(byte[] b, int off) {
        int i = off;
        b[i++] = alphabet[this.buffer[0] >> 2 & 0x3F];
        if (!this.oneLine) {
            i += this.checkLine(b, i);
        }
        b[i++] = alphabet[this.buffer[0] << 4 & 0x3F | this.buffer[1] >> 4 & 0xF];
        if (!this.oneLine) {
            i += this.checkLine(b, i);
        }
        int n = b[i++] = this.position > 1 ? alphabet[this.buffer[1] << 2 & 0x3F | this.buffer[2] >> 6 & 3] : 61;
        if (!this.oneLine) {
            i += this.checkLine(b, i);
        }
        int n2 = b[i++] = this.position > 2 ? alphabet[this.buffer[2] & 0x3F] : 61;
        if (!this.oneLine) {
            i += this.checkLine(b, i);
        }
        int j = 0;
        while (j < this.buffer.length) {
            this.buffer[j++] = 0;
        }
        this.position = 0;
        return i - off;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int j = 0;
        byte[] output = new byte[Math.max(len * 2, 6)];
        for (int i = off; i < off + len && i < b.length; ++i) {
            this.buffer[this.position++] = b[i];
            if (this.position != this.buffer.length) continue;
            j += this.encode(output, j);
        }
        this.out.write(output, 0, j);
    }
}

