/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.io;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.function.IntUnaryOperator;

public class EscapedUnicodeFilterReader
extends FilterReader {
    private static final int BACK_SLASH = 0;
    private static final int U = 1;
    private static final int HEX = 2;
    private static final int OTHER = 3;
    private static final int START = 0;
    private static final int U1 = 1;
    private static final int U2 = 2;
    private static final int H1 = 3;
    private static final int H2 = 4;
    private static final int H3 = 5;
    private static final int ACCEPT = 6;
    private static final int[][] FSM = new int[][]{{1, 0, 0, 0}, {0, 2, 0, 0}, {0, 0, 3, 0}, {0, 0, 4, 0}, {0, 0, 5, 0}, {0, 0, 6, 0}};
    private boolean end = false;

    public EscapedUnicodeFilterReader(Reader in) throws IOException {
        super(new PushbackReader(new BufferedReader(in), 1024));
    }

    private static int category(int c) {
        IntUnaryOperator hexOrOther = ch -> ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70 ? 2 : 3;
        IntUnaryOperator uOr = ch -> c == 117 ? 1 : hexOrOther.applyAsInt(ch);
        return c == 92 ? 0 : uOr.applyAsInt(c);
    }

    @Override
    public int read() throws IOException {
        char[] b = new char[1];
        return this.read(b, 0, b.length) == -1 ? -1 : 0xFFFF & b[0];
    }

    @Override
    public int read(char[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        int i;
        if (this.end) {
            return -1;
        }
        for (i = 0; i < len && !this.end; ++i) {
            int c = this.readOneCharacter();
            if (c != -1) {
                b[off + i] = (char)c;
                continue;
            }
            this.end = true;
            --i;
        }
        return i == 0 && this.end ? -1 : i;
    }

    private int readOneCharacter() throws IOException {
        StringBuilder buffer = new StringBuilder();
        int state = 0;
        int c = this.in.read();
        while (c != -1 && (state = FSM[state][EscapedUnicodeFilterReader.category(c)]) != 0 && state != 6) {
            buffer.append(c);
            c = this.in.read();
        }
        if (state == 6) {
            return Integer.parseInt(buffer.substring(2) + new String(new char[]{(char)c}), 16);
        }
        if (buffer.length() == 0) {
            return c;
        }
        ((PushbackReader)this.in).unread(c);
        if (buffer.length() > 1) {
            ((PushbackReader)this.in).unread(buffer.substring(1).toCharArray());
        }
        return buffer.length() > 0 ? (int)buffer.charAt(0) : -1;
    }
}

