/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;
import net.pincette.io.StreamConnector;
import net.pincette.util.Util;

public class FileRotateOutputStream
extends OutputStream {
    private final int depth;
    private final long size;
    private final File file;
    private OutputStream out;

    public FileRotateOutputStream(String filename, int depth, long size) {
        this(new File(filename), depth, size);
    }

    public FileRotateOutputStream(File file, int depth, long size) {
        this.file = file;
        this.depth = depth;
        this.size = size;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    private OutputStream rotate() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        for (int i = this.depth; i >= 1; --i) {
            File log = new File(this.file.getAbsolutePath() + "." + i + ".gz");
            if (!log.exists()) continue;
            if (i == this.depth) {
                Files.delete(log.toPath());
                continue;
            }
            if (log.renameTo(new File(this.file.getAbsolutePath() + "." + (i + 1) + ".gz"))) continue;
            throw new IOException("Rename failed");
        }
        Util.tryToDoWithRethrow(() -> new FileInputStream(this.file), in -> StreamConnector.copy(in, new GZIPOutputStream(new FileOutputStream(this.file.getAbsolutePath() + ".1.gz"))));
        Files.delete(this.file.toPath());
        return new FileOutputStream(this.file);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Supplier<OutputStream> ifExceeded = () -> this.file.length() + (long)len > this.size ? (OutputStream)Util.tryToGetRethrow(this::rotate).orElse(null) : this.out;
        OutputStream outputStream = this.out = !this.file.exists() || this.out == null && this.file.length() + (long)len <= this.size ? new FileOutputStream(this.file, true) : ifExceeded.get();
        if (this.out != null) {
            this.out.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }
}

