/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamConnector {
    private StreamConnector() {
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        StreamConnector.copy(in, out, true, true);
    }

    public static void copy(InputStream in, OutputStream out, boolean closeInput, boolean closeOutput) throws IOException {
        StreamConnector.copy(in, out, 65536, closeInput, closeOutput);
    }

    public static void copy(InputStream in, OutputStream out, boolean closeInput, boolean closeOutput, boolean flush) throws IOException {
        StreamConnector.copy(in, out, 65536, closeInput, closeOutput, flush);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize, boolean closeInput, boolean closeOutput) throws IOException {
        StreamConnector.copy(in, out, bufferSize, closeInput, closeOutput, true);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize, boolean closeInput, boolean closeOutput, boolean flush) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
            if (!flush) continue;
            out.flush();
        }
        if (closeInput) {
            in.close();
        }
        if (closeOutput) {
            out.close();
        } else if (flush) {
            out.flush();
        }
    }
}

