/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jes.test;

import com.typesafe.config.Config;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import net.pincette.jes.test.Test;
import net.pincette.jes.util.Configuration;
import net.pincette.jes.util.Streams;
import net.pincette.json.JsonUtil;
import net.pincette.util.ArgsBuilder;
import net.pincette.util.Util;

public class Application {
    private static final String DEV = "dev";
    private static final String DIRECTORY = "directory";
    private static final String DIRECTORY_OPT = "--directory";
    private static final String DIRECTORY_OPT_SHORT = "-d";
    private static final String ENVIRONMENT = "environment";
    private static final String KAFKA = "kafka";

    private static ArgsBuilder adder(ArgsBuilder builder, String arg) {
        switch (arg) {
            case "--directory": 
            case "-d": {
                return builder.addPending(DIRECTORY);
            }
        }
        return builder.add(arg);
    }

    public static void main(String[] args) {
        Arrays.stream(args).reduce(new ArgsBuilder(), Application::adder, (b1, b2) -> b1).build().filter(map -> map.containsKey(DIRECTORY)).map(Application::test).orElse(Application::usage).run();
        System.exit(0);
    }

    public static void report(String filename, JsonObject command, JsonObject expected, JsonArray patch) {
        System.out.println(filename);
        if (!patch.isEmpty()) {
            System.out.println("ERROR");
            System.out.println("The reply for the command");
            System.out.println(JsonUtil.string(command));
            System.out.println("and the expected result");
            System.out.println(JsonUtil.string(expected));
            System.out.println("have the following differences");
            System.out.println(JsonUtil.string(patch));
        } else {
            System.out.println("OK");
        }
    }

    private static Runnable test(Map<String, String> options) {
        return () -> {
            Config config = Configuration.loadDefault();
            if (!Test.run(new File((String)options.get(DIRECTORY)).toPath(), Streams.fromConfig(config, KAFKA), Util.tryToGetSilent(() -> config.getString(ENVIRONMENT)).orElse(DEV), Application::report)) {
                System.out.println("Some tests failed");
                System.exit(1);
            }
            System.out.println("Tests succeeded");
        };
    }

    private static void usage() {
        System.err.println("Usage: net.pincette.jes.test.Application (-d | --directory) directory");
        System.exit(1);
    }
}

