/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jes.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.util.Optional;
import net.pincette.util.Or;
import net.pincette.util.Util;

public class Configuration {
    private Configuration() {
    }

    private static Config asFile() {
        return Optional.ofNullable(System.getProperty("config.file")).flatMap(file -> Util.tryToGetRethrow(() -> ConfigFactory.parseFile(new File((String)file)))).orElse(null);
    }

    private static Config asResource() {
        return Optional.ofNullable(System.getProperty("config.resource")).flatMap(resource -> Util.tryToGetRethrow(() -> ConfigFactory.parseFile(new File(new File("conf"), (String)resource)))).orElse(null);
    }

    private static Config defaultConfig() {
        return Util.tryToGetSilent(() -> ConfigFactory.parseFile(new File(new File("conf"), "application.conf"))).orElse(null);
    }

    public static Config loadDefault() {
        return Or.tryWith(Configuration::asFile).or(Configuration::asResource).or(Configuration::defaultConfig).get().orElseGet(ConfigFactory::load);
    }
}

