/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jes.util;

import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import net.pincette.jes.util.Util;
import net.pincette.json.JsonUtil;
import net.pincette.json.Patch;
import net.pincette.util.Builder;
import net.pincette.util.Pair;
import net.pincette.util.Util;

public class Event {
    private static final Pattern SEQ_SUFFIX = Pattern.compile("-\\d{6,}");

    private Event() {
    }

    public static boolean added(JsonObject event, String jsonPointer) {
        return Optional.ofNullable(event.getJsonArray("_ops")).flatMap(ops -> Optional.ofNullable(event.getJsonObject("_before")).map(before -> Pair.pair(ops, before))).map(pair -> Patch.added((JsonArray)pair.first, (JsonObject)pair.second, jsonPointer)).orElse(false);
    }

    public static JsonObject applyEvent(JsonObject aggregate, JsonObject event) {
        return net.pincette.util.Util.tryToGet(() -> Builder.create(() -> JsonUtil.createObjectBuilder(JsonUtil.createPatch(event.getJsonArray("_ops")).apply(aggregate).asJsonObject())).update(b -> b.add("_id", Event.stripSequenceNumber(event.getString("_id")))).update(b -> b.add("_type", event.getString("_type"))).update(b -> b.add("_corr", event.getString("_corr"))).update(b -> b.add("_seq", event.getInt("_seq"))).updateIf(() -> Optional.ofNullable(event.getJsonNumber("_timestamp")), (b, t) -> b.add("_timestamp", (JsonValue)t)).updateIf(() -> Optional.ofNullable(event.getJsonObject("_jwt")), (b, jwt) -> b.add("_jwt", (JsonValue)jwt)).build().build(), e -> {
            throw new Util.GeneralException("Event: " + JsonUtil.string(event) + ": " + e.getMessage());
        }).orElse(null);
    }

    static Function<JsonObject, JsonObject> applyEvent() {
        return Event.applyEvent(null);
    }

    static Function<JsonObject, JsonObject> applyEvent(JsonObject snapshot) {
        return net.pincette.util.Util.accumulate(Event::applyEvent, snapshot != null ? snapshot : JsonUtil.emptyObject());
    }

    public static boolean changed(JsonObject event, String jsonPointer) {
        return Optional.ofNullable(event.getJsonArray("_ops")).map(ops -> Patch.changed(ops, jsonPointer)).orElse(false);
    }

    public static boolean changed(JsonObject event, String jsonPointer, JsonValue from, JsonValue to) {
        return Optional.ofNullable(event.getJsonArray("_ops")).flatMap(ops -> Optional.ofNullable(event.getJsonObject("_before")).filter(before -> JsonUtil.getValue(before, jsonPointer).filter(value -> value.equals(from)).isPresent()).map(before -> Pair.pair(ops, before))).map(pair -> Patch.changed((JsonArray)pair.first, (JsonObject)pair.second, jsonPointer, from, to)).orElse(false);
    }

    private static boolean hasOps(JsonObject event) {
        return Optional.ofNullable(event.getJsonArray("_ops")).filter(ops -> !ops.isEmpty()).isPresent();
    }

    public static boolean isEvent(JsonObject event) {
        return Util.isManagedObject(event) && Event.hasOps(event);
    }

    public static boolean isNext(JsonObject aggregate, JsonObject event) {
        return event.getInt("_seq") == aggregate.getInt("_seq") + 1;
    }

    public static boolean removed(JsonObject event, String jsonPointer) {
        return Optional.ofNullable(event.getJsonArray("_ops")).map(ops -> Patch.removed(ops, jsonPointer)).orElse(false);
    }

    public static String sequenceErrorMessage(JsonObject aggregate, JsonObject event) {
        return "SEQUENCE ERROR: event received for (" + aggregate.getString("_id") + "," + aggregate.getString("_type") + ") with sequence number " + event.getInt("_seq") + ", while " + (aggregate.getInt("_seq") + 1) + " was expected";
    }

    private static String stripSequenceNumber(String id) {
        return Optional.of(id.lastIndexOf(45)).filter(index -> index != -1 && SEQ_SUFFIX.matcher(id.substring((int)index)).matches()).map(index -> id.substring(0, (int)index)).orElse(id);
    }
}

