/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jes.util;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import net.pincette.util.Util;

public class Href {
    private static String contextPath;
    public final String app;
    public final String id;
    public final String type;

    public Href(String app, String type) {
        this(app, type, null);
    }

    public Href(String app, String type, String id) {
        this.app = app;
        this.type = Href.addPrefix(app, type);
        this.id = id;
    }

    public Href(String href) {
        String[] path = Href.getPath(href);
        this.id = Href.getId(path);
        this.app = path[path.length - (this.id != null ? 3 : 2)];
        this.type = Href.addPrefix(this.app, path[path.length - (this.id != null ? 2 : 1)]);
    }

    private static String addPrefix(String app, String type) {
        return Optional.of(type.indexOf(45)).filter(index -> index == -1).map(index -> app + "-" + type).orElse(type);
    }

    private static String getId(String[] path) {
        return Optional.of(path).map(p -> p[((String[])p).length - 1]).filter(Util::isUUID).orElse(null);
    }

    private static String[] getPath(String href) {
        String[] path = Href.split(href);
        if (path.length < 2 || Href.getId(path) != null && path.length < 3) {
            throw new Util.GeneralException("Invalid href " + href);
        }
        return path;
    }

    private static String removePrefix(String type) {
        return Optional.of(type.indexOf(45)).filter(index -> index != -1).map(index -> type.substring(index + 1)).orElse(type);
    }

    public static void setContextPath(String path) {
        if (contextPath != null) {
            throw new Util.GeneralException("The href context path can be set only once.");
        }
        contextPath = path;
    }

    private static String[] split(String href) {
        return (String[])Util.getSegments(href.startsWith("/") ? href : Util.tryToGetRethrow(() -> new URI(href)).map(URI::getPath).orElse(""), "/").toArray(String[]::new);
    }

    public boolean equals(Object other) {
        return other instanceof Href && ((Href)other).app.equals(this.app) && ((Href)other).type.equals(this.type) && ((Href)other).id.equals(this.id);
    }

    public int hashCode() {
        return Objects.hash(this.app, this.id, this.type);
    }

    public String path() {
        return (contextPath != null ? contextPath : "") + "/" + this.app + "/" + Href.removePrefix(this.type) + (String)(this.id != null ? "/" + this.id : "");
    }
}

