/*
 * Decompiled with CFR 0.152.
 */
package net.pincette.jes.util;

import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import net.pincette.json.JsonUtil;
import net.pincette.json.filter.JacksonParser;
import net.pincette.json.filter.JsonParserWrapper;
import net.pincette.util.Util;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonDeserializer
implements Deserializer<JsonObject> {
    private final CBORFactory factory = CBORFactory.builder().build();

    private static JsonObject getObject(JsonParser parser) {
        if (parser.next() != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException("Not an object");
        }
        return parser.getObject();
    }

    private static Optional<JsonObject> parse(byte[] bytes) {
        return JsonUtil.from(new String(bytes, StandardCharsets.UTF_8)).filter(JsonUtil::isObject).map(JsonValue::asJsonObject);
    }

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> map, boolean isKey) {
    }

    @Override
    public JsonObject deserialize(String topic, byte[] bytes) {
        return Optional.ofNullable(bytes).map(b -> this.fromCbor((byte[])b).orElseGet(() -> JsonDeserializer.parse(bytes).orElse(null))).orElse(null);
    }

    private Optional<JsonObject> fromCbor(byte[] bytes) {
        return Util.tryToGetWithSilent(() -> new JsonParserWrapper(new JacksonParser(this.factory.createParser(new GZIPInputStream(new ByteArrayInputStream(bytes))))), JsonDeserializer::getObject);
    }
}

